#!/usr/bin/python3
# -*- coding: utf8 -*-

class ml_data(object):
    def __init__(self, langs):
        self.lang = [i.lower() for i in langs]  # list language other than default

class ml_server(object):
    def __init__(self, data, lang="default"):
        try:
            idx = data.lang.index(lang.lower() ) + 1
        except ValueError:
            idx = 0
        for i in dir(data):
            if not i.startswith('m'): continue
            try:
                val = getattr(data, i)[idx]
            except IndexError:
                val = "!!NO_DEF!!"
            setattr(self, i, val)

def test_all(ml_d):
    langs = ["default"] + ml_d.lang
    lang_w = max([len(i) for i in langs] )
    svrs =  [ml_server(ml_d, i) for i in langs]
    attrs = sorted([i for i in dir(svrs[0] ) if i.startswith('m') ] )
    for i in attrs:
        for j,k in zip(langs,svrs):
            print(("%s(%" + str(lang_w) + "s) %s")%(i, j, repr(getattr(k, i) ) ) )

def test():
    S = ml_data(["ja"] )
    S.m000 = [
        "Tools: Default langage",
        "Tools: 日本語",
    ]
    S.m001 = [
        "Tools: English message",
        "Tools: 日本語のメッセージ",
    ]
    S.m002 = [  # missing definition for lang0
        "Tools: English message 2",
    ]
    S.m003 = [] # empty definition
    test_all(S)

if __name__ == "__main__":
    test()
