#!/usr/bin/python3
# -*- coding: utf8 -*-

import sys, termios
from select import select

# http://code.activestate.com/recipes/572182-how-to-implement-kbhit-on-linux/

# save the terminal settings
fd = sys.stdin.fileno()
new_term = termios.tcgetattr(fd)
old_term = termios.tcgetattr(fd)

# new terminal setting unbuffered
new_term[3] = (new_term[3] & ~termios.ICANON & ~termios.ECHO)

# switch to normal terminal
def set_normal_term():
    termios.tcsetattr(fd, termios.TCSAFLUSH, old_term)

# switch to unbuffered terminal
def set_curses_term():
    termios.tcsetattr(fd, termios.TCSAFLUSH, new_term)

def putch(ch):
    sys.stdout.write(ch)

def getch():
    return sys.stdin.read(1)

def getche():
    ch = getch()
    putch(ch)
    return ch

def kbhit():
    dr,dw,de = select([sys.stdin], [], [], 0)
    return dr != []

if __name__ == '__main__':
    import atexit, time
    atexit.register(set_normal_term)
    set_curses_term()

    while 1:
        if kbhit():
            ch = getche()
            print()
            break
        time.sleep(0.010)
        # sys.stdout.write('.')

    print('done')

