#!/usr/bin/python3
# -*- coding: utf8 -*-

# Public modules
from __future__ import print_function
import glob, os, sys

DATA_ROOT = "CAIR_ROOT/data"
CSV_HDR = """Ident,cna_000000
Tag,hogehoge
FileName,00000000000000.csv
ODR,3200
N_Samples,32000
Act_ms,10180.794
Vdd3V3,2.998
RAccAveX,1.304607
RAccAveY,0.069314
RAccAveZ,9.954087
RAccPkXP,50
RAccPkXN,16
RAccPkYP,19
RAccPkYN,-13
RAccPkZP,276
RAccPkZN,231
HAccPkXP,0.662702
HAccPkXN,-0.737920
HAccPkYP,0.720628
HAccPkYN,-0.569565
HAccPkZP,0.957490
HAccPkZN,-0.897552
HAccPk3D,0.967522
HAccRmsX,0.145424
HAccRmsY,0.126376
HAccRmsZ,0.197309
HAccRms3D,0.275772
VelPkXP,0.782174
VelPkXN,-0.955741
VelPkYP,0.750261
VelPkYN,-0.680503
VelPkZP,0.960131
VelPkZN,-1.146381
VelPk3D,1.258595
VelRmsX,0.206635
VelRmsY,0.189365
VelRmsZ,0.287860
VelRms3D,0.401771
END_Summary,0
"""
CSV_LINE = "1.372000,0.078400,9.486400,0.016855,0.096149,-0.460633,0.470863,-0.000062,0.015487,-0.162889,0.163624"
CNA_BYTES = 128512

def help():
    usage = """usage:
\t./gen_dummy_data.py num [s|n]
\t\tnum: number of dummy files/directory (0 for remove dummy files)
\t\ts    gnenrate summary csv
\t\tn    generate cna"""
    print(usage)
    sys.exit(0)

# check args
if len(sys.argv) < 2:
    help()

try:
    num_files = int(sys.argv[1] )
except ValueError:
    num_files = -1
if num_files < 0: help()

if   len(sys.argv) == 2:            # Full csv
    dummy_data = CSV_HDR + 32000*CSV_LINE
    dummy_ext = "csv"
elif sys.argv[2].lower() == 'n':    # cna
    dummy_data = CNA_BYTES*'?'
    dummy_ext = "cna"
elif sys.argv[2].lower() == 's':    # Summary csv
    dummy_data = CSV_HDR
    dummy_ext = "csv"
else: help()

dirs = [os.path.join(DATA_ROOT,i) for i in os.listdir(DATA_ROOT) if os.path.isdir(os.path.join(DATA_ROOT,i) ) ]
dirs.sort()
for d in dirs:
    print(d)
    # First, remove existing dummy files
    test = os.path.join(d,"00*")
    r = glob.glob(test)
    for i in r:
       os.remove(i)
    # Write dummy files
    for n in range(num_files):
        name = os.path.join(d,"%014d.%s"%(n+1,dummy_ext))
        with open(name, "wb") as f:
            f.write(dummy_data)
