""" Sample Data Decoder """
import os,sys,struct,time
import numpy as np
import EEMA_core
_stop_request = False

# https://stackoverflow.com/questions/14215303/scipy-with-py2exe
def dependencies_for_myprogram():
    from scipy.sparse.csgraph import _validation

def parse(i):
    signed = lambda x: x - 0x400 if x & 0x0200 else x
    exp = i >> 30
    x = signed(0x000003ff & i) << exp
    y = signed((0x000ffc00 & i) >> 10) << exp
    z = signed((0x3ff00000 & i) >> 20) << exp
    return x,y,z

# def iir(k,v,ini=None):
    # y1 = iir_sub_1(k,v,ini)
    # y2 = iir_sub_2(k,v,ini)
    # d = y1 - y2
    # print "iir error: %e - %e"%(d.min(),d.max() )
    # return y1

def iir_sub_1(k,v,ini=None):
    r0,r1,r2 = (0,0,0) if ini is None else ini
    o = []
    for i in v:
        if _stop_request: break
        i1 = i  - r0
        i2 = i1 - r1
        o.append(i2 - r2)
        r0 = k[1] * r0 + k[0] * i
        r1 = k[1] * r1 + k[0] * i1
        r2 = k[1] * r2 + k[0] * i2
    return np.array(o)

# def iir_sub_2(k,v,ini=None):
def iir(k,v,ini=None):
    a,b = k
    i0,i1,i2 = (0,0,0) if ini is None else ini
    y0 = EEMA_core.HPF(v,a,b,i0)
    y1 = EEMA_core.HPF(y0,a,b,i1)
    y2 = EEMA_core.HPF(y1,a,b,i2)
    return y2

def fft(v,odr,start_sec,len_sec):
    pstart = int(round(odr * start_sec) )
    plen = 1+2*(int(round(odr * len_sec) )//2)  # Make odd number
    x = v[pstart:pstart+plen] * np.hamming(plen)
    f = np.fft.fft(x)
    p = (f*f.conjugate() ).real
    m = p[:(plen-1)/2+1]
    m[1:] *= 2
    return m**0.5

# def velocity(k,v,odr,ini=None):
    # y1 = velocity_sub_1(k,v,odr,ini)
    # y2 = velocity_sub_2(k,v,odr,ini)
    # d = y1 - y2
    # print "velocity error: %e - %e"%(d.min(),d.max() )
    # return y1

def velocity_sub_1(k,v,odr,ini=None):
    r = 0 if ini is None else ini
    dt = 1e3/odr
    o = []
    for i in v:
        if _stop_request: break
        r *= k[1]
        r += dt*i
        o.append(r)
    return np.array(o)

# def velocity_sub_2(k,v,odr,ini=None):
def velocity(k,v,odr,ini=None):
    a = 1e3/odr
    b = k[1]
    i = 0 if ini is None else ini
    return EEMA_core.EEMA(v,a,b,i)


class saver(object):
    def __init__(self):
        pass
    def stop(self):
        global _stop_request
        _stop_request = True
    def set_identity(self,id,ts):
        self.ID = id
        self.ts = ts
        self.FileName = time.strftime("%Y%m%d%H%M%S.csv", time.localtime(ts) )
    def set_data(self,data):
        dbl_fmt = "%dd"%((512-64)/8)
        self.dbldata = struct.unpack(dbl_fmt,data[:512-64] )
        # print "ID:",self.ID
        # print "FileName:",self.FileName
        # print "DBL_DATA"
        # for n,i in zip(range(len(self.dbldata) ),self.dbldata):
            # print "%2d: %f,"%(n,i),
        # print
        fmt = "%dI"%((len(data)-512+64)/4)
        self.bdata = struct.unpack(fmt,data[512-64:] )
        # print "Length of bdata = %d"%len(self.bdata)


    def main(self,summary=False):
        data,ID,FileName,dbldata = self.bdata,self.ID,self.FileName,self.dbldata

        # CSV file -- Summary top
        o = "FileName,%s\n"%(FileName)

        # CSV file -- Summary values
        dbl_datakey = 'Vdd3V3 AccAveX AccAveY AccAveZ AccAveT'
        dbl_datakey +=' AccPkXP AccPkXN AccPkYP AccPkYN AccPkZP AccPkZN AccPkT'
        dbl_datakey +=' AccRmsX AccRmsY AccRmsZ AccRmsT'
        dbl_datakey +=' VelPkXP VelPkXN VelPkYP VelPkYN VelPkZP VelPkZN VelPkT'
        dbl_datakey +=' VelRmsX VelRmsY VelRmsZ VelRmsT'
        dbl_datakey +=' IIR_K1 IIR_K2 IIRiniX0 IIRiniX1 IIRiniX2 IIRiniXV IIRiniY0 IIRiniY1'
        dbl_datakey +=' IIRiniY2 IIRiniYV IIRiniZ0 IIRiniZ1 IIRiniZ2 IIRiniZV'
        dbl_datakey +=' ODR ACT_STIME AccRPkXP AccRPkXN AccRPkYP AccRPkYN AccRPkZP AccRPkZN'
        dbl_datakey +=' AP_RSSI Dev_Tmp'    # V2
        dbl_datakey +=' Versions'           # BTS V2.0.3
        
        dbl_datakey = dbl_datakey.split()
        dd_dct = {}
        for k,v in zip(dbl_datakey,dbldata):
            dd_dct[k] = v

        o += "ODR,%.0f\n"%dd_dct["ODR"]
        o += "N_Samples,%d\n"%len(data)
        o += "Act_ms,%.3f\n"%(1e-3*dd_dct["ACT_STIME"] )
        o += "Vdd3V3,%.3f\n"%dd_dct["Vdd3V3"]
        o += "RAccAveX,%.6f\n"%dd_dct["AccAveX"]
        o += "RAccAveY,%.6f\n"%dd_dct["AccAveY"]
        o += "RAccAveZ,%.6f\n"%dd_dct["AccAveZ"]
        o += "RAccPkXP,%.0f\n"%dd_dct["AccRPkXP"]
        o += "RAccPkXN,%.0f\n"%dd_dct["AccRPkXN"]
        o += "RAccPkYP,%.0f\n"%dd_dct["AccRPkYP"]
        o += "RAccPkYN,%.0f\n"%dd_dct["AccRPkYN"]
        o += "RAccPkZP,%.0f\n"%dd_dct["AccRPkZP"]
        o += "RAccPkZN,%.0f\n"%dd_dct["AccRPkZN"]
        o += "HAccPkXP,%.6f\n"%dd_dct["AccPkXP"]
        o += "HAccPkXN,%.6f\n"%dd_dct["AccPkXN"]
        o += "HAccPkYP,%.6f\n"%dd_dct["AccPkYP"]
        o += "HAccPkYN,%.6f\n"%dd_dct["AccPkYN"]
        o += "HAccPkZP,%.6f\n"%dd_dct["AccPkZP"]
        o += "HAccPkZN,%.6f\n"%dd_dct["AccPkZN"]
        o += "HAccPk3D,%.6f\n"%dd_dct["AccPkT"]
        o += "HAccRmsX,%.6f\n"%dd_dct["AccRmsX"]
        o += "HAccRmsY,%.6f\n"%dd_dct["AccRmsY"]
        o += "HAccRmsZ,%.6f\n"%dd_dct["AccRmsZ"]
        o += "HAccRms3D,%.6f\n"%dd_dct["AccRmsT"]
        o += "VelPkXP,%.6f\n"%dd_dct["VelPkXP"]
        o += "VelPkXN,%.6f\n"%dd_dct["VelPkXN"]
        o += "VelPkYP,%.6f\n"%dd_dct["VelPkYP"]
        o += "VelPkYN,%.6f\n"%dd_dct["VelPkYN"]
        o += "VelPkZP,%.6f\n"%dd_dct["VelPkZP"]
        o += "VelPkZN,%.6f\n"%dd_dct["VelPkZN"]
        o += "VelPk3D,%.6f\n"%dd_dct["VelPkT"]
        o += "VelRmsX,%.6f\n"%dd_dct["VelRmsX"]
        o += "VelRmsY,%.6f\n"%dd_dct["VelRmsY"]
        o += "VelRmsZ,%.6f\n"%dd_dct["VelRmsZ"]
        o += "VelRms3D,%.6f\n"%dd_dct["VelRmsT"]
        o += "AP_RSSI,%.1f\n"%dd_dct["AP_RSSI"] # V2
        o += "Dev_Tmp,%.1f\n"%dd_dct["Dev_Tmp"] # V2
        o += "END_Summary,0\n"

        if not summary:
            odr = dbldata[41]

            # IIR Params
            iirk = dbldata[27:29]
            xyz_ini_av = dbldata[29:41]
            
            x = []
            y = []
            z = []
            for i in data:
                s,t,u = parse(i)
                x.append(s)
                y.append(t)
                z.append(u)
            k = 4e-3*9.8

            # xl = (0.0,0.2)
            xl = (None,None)
            # xl = (3.45,3.65)

            # print "\n!!!!!!!!!!!! X:",
            x_hf = k*iir(iirk,x,xyz_ini_av[0:3] )
            # print "\n!!!!!!!!!!!! Y:",
            y_hf = k*iir(iirk,y,xyz_ini_av[4:7] )
            # print "\n!!!!!!!!!!!! Z:",
            z_hf = k*iir(iirk,z,xyz_ini_av[8:11] )
            # print "\n!!!!!!!!!!!! X:",
            x_v = velocity(iirk,x_hf,odr,k*xyz_ini_av[3] )
            # print "\n!!!!!!!!!!!! Y:",
            y_v = velocity(iirk,y_hf,odr,k*xyz_ini_av[7] )
            # print "\n!!!!!!!!!!!! Z:",
            z_v = velocity(iirk,z_hf,odr,k*xyz_ini_av[11] )
            x = k*np.array(x,dtype=np.double)
            y = k*np.array(y,dtype=np.double)
            z = k*np.array(z,dtype=np.double)
            t = 1./3200*np.arange(len(data),dtype=np.double)
            # t = np.arange(len(data),dtype=np.double)

            # armsx = np.std(x)
            # armsy = np.std(y)
            # armsz = np.std(z)
            # hrmsx = np.std(x_hf)
            # hrmsy = np.std(y_hf)
            # hrmsz = np.std(z_hf)
            # vrmsx = np.std(x_v)
            # vrmsy = np.std(y_v)
            # vrmsz = np.std(z_v)

        # CSV file -- Detail Data
        if not summary:
            for RAccX,RAccY,RAccZ,HAccX,HAccY,HAccZ,VelX,VelY,VelZ in zip(x,y,z,x_hf,y_hf,z_hf,x_v,y_v,z_v):
                if _stop_request: break
                HAcc3D = (HAccX**2 + HAccY**2 + HAccZ**2)**0.5
                Vel3D  = (VelX**2 +  VelY**2 +  VelZ**2)**0.5
                o += "%.6f,%.6f,%.6f,%.6f,%.6f,%.6f,%.6f,%.6f,%.6f,%.6f,%.6f\n"%(RAccX,RAccY,RAccZ,HAccX,HAccY,HAccZ,HAcc3D,VelX,VelY,VelZ,Vel3D)

        return ID,FileName,o
