#!/usr/bin/python3
# -*- coding: utf8 -*-

from __future__ import print_function
import os,time

DEFAULT_SIZE_KB = 100
INTERVAL_SEC = 3600
GENERATION = 3
MAX_AGE = 24*60*60
_lasttime = {}
_last_chk = time.time()

def rotate(path,limit_kb=DEFAULT_SIZE_KB,intvl_sec=INTERVAL_SEC,gen=GENERATION):
    global _lasttime,_last_chk
    limit_byte = 1024 * limit_kb
    now = time.time()
    max_gen = 0

    # Age _lasttime
    if (now - _last_chk) > MAX_AGE:
        _last_chk = now
        k_to_del = []
        for k in _lasttime.keys():
            if _lasttime[k] < _last_chk:
                k_to_del.append(k)
        for k in k_to_del:
            del _lasttime[k]

    # Execution control
    if not os.path.exists(path) or not os.path.isfile(path):
        return  # Do-nothing for not existing file
    last = _lasttime.get(path,0)
    if (now - last) < intvl_sec:
        return  # Not now
    if os.stat(path).st_size < limit_byte:
        return  # Not now

    # OK, do it!
    _lasttime[path] = now
    dir,name = os.path.split(path)
    parts = name.split('.')
    body = os.path.join(dir,'.'.join(parts[:-1] ) )
    ext = parts[-1]

    # Delete oldest generation if exists
    oldest = body + "_%d."%gen + ext
    if os.path.exists(oldest):
        os.remove(oldest)
        max_gen = gen

    # Rotate
    for i in range(1,gen+1):
        g = gen - i
        src = body + ("_%d."%g if g>0 else ".") + ext
        if os.path.exists(src):
            dst = body + "_%d."%(g+1) + ext
            os.rename(src,dst)
            max_gen = max(max_gen,g+1)
    # touch
    with open(src,"w") as f:
        pass
    return max_gen

if __name__ == "__main__":
    # Test dir
    tdir = "rotate_test"
    def list_files(pttrn,msg):
        files = [i for i in os.listdir(tdir) if i.startswith(pttrn) ]
        files.sort()
        print(msg+":",files)
    if not os.path.exists(tdir):
        os.makedirs(tdir)
    else:
        # Empty the dir
        for f in os.listdir(tdir):
            p = os.path.join(tdir,f)
            if os.path.isfile(p):
                os.remove(p)
    test_path1 = os.path.join(tdir,"testfile.not.rotate.txt")
    test_path2 = os.path.join(tdir,"testfile.must.rotate.txt")
    test_path3 = os.path.join(tdir,"testfile.interval.test.txt")

    list_files("test", "Initial")

    msg = "Not rotate test "
    data = msg + (1023-len(msg) ) * "1"
    with open(test_path1,"wb") as f:
        f.write(data)
    list_files('.'.join(os.path.split(test_path1)[-1].split('.')[:-1] ), msg+'0')
    # 1st try
    _lasttime = {}  # Reset lasttime
    max_gen = rotate(test_path1,1)
    list_files('.'.join(os.path.split(test_path1)[-1].split('.')[:-1] ), msg+'1, max_gen=%r'%max_gen)
    # 2nd try
    data = msg + (1023-len(msg) ) * "2"
    with open(test_path1,"wb") as f:
        f.write(data)
    _lasttime = {}  # Reset lasttime
    max_gen = rotate(test_path1,1)
    list_files('.'.join(os.path.split(test_path1)[-1].split('.')[:-1] ), msg+'2, max_gen=%r'%max_gen)
    # 3rd try
    data = msg + (1023-len(msg) ) * "3"
    with open(test_path1,"wb") as f:
        f.write(data)
    _lasttime = {}  # Reset lasttime
    max_gen = rotate(test_path1,1)
    list_files('.'.join(os.path.split(test_path1)[-1].split('.')[:-1] ), msg+'3, max_gen=%r'%max_gen)
    # 4th try
    data = msg + (1023-len(msg) ) * "4"
    with open(test_path1,"wb") as f:
        f.write(data)
    _lasttime = {}  # Reset lasttime
    max_gen = rotate(test_path1,1)
    list_files('.'.join(os.path.split(test_path1)[-1].split('.')[:-1] ), msg+'4, max_gen=%r'%max_gen)

    msg = "Must rotate test"
    data = msg + (1024-len(msg) ) * "1"
    with open(test_path2,"wb") as f:
        f.write(data)
    list_files('.'.join(os.path.split(test_path2)[-1].split('.')[:-1] ), msg+'0')
    # 1st try
    _lasttime = {}  # Reset lasttime
    max_gen = rotate(test_path2,1)
    list_files('.'.join(os.path.split(test_path2)[-1].split('.')[:-1] ), msg+'1, max_gen=%r'%max_gen)
    data = msg + (1024-len(msg) ) * "2"
    with open(test_path2,"wb") as f:
        f.write(data)
    # 2nd try
    _lasttime = {}  # Reset lasttime
    max_gen = rotate(test_path2,1)
    list_files('.'.join(os.path.split(test_path2)[-1].split('.')[:-1] ), msg+'2, max_gen=%r'%max_gen)
    data = msg + (1024-len(msg) ) * "3"
    with open(test_path2,"wb") as f:
        f.write(data)
    # 3rd try
    _lasttime = {}  # Reset lasttime
    max_gen = rotate(test_path2,1)
    list_files('.'.join(os.path.split(test_path2)[-1].split('.')[:-1] ), msg+'3, max_gen=%r'%max_gen)
    data = msg + (1024-len(msg) ) * "4"
    with open(test_path2,"wb") as f:
        f.write(data)
    # 4th try
    _lasttime = {}  # Reset lasttime
    max_gen = rotate(test_path2,1)
    list_files('.'.join(os.path.split(test_path2)[-1].split('.')[:-1] ), msg+'4, max_gen=%r'%max_gen)
    
    msg =  "Interval test"
    data = msg + (1024-len(msg) ) * "1"
    with open(test_path3,"wb") as f:
        f.write(data)
    list_files('.'.join(os.path.split(test_path3)[-1].split('.')[:-1] ), msg+'0')
    # 1st try -- should rotate (original + gen1)
    _lasttime = {}  # Reset lasttime
    max_gen = rotate(test_path3,1,3)
    list_files('.'.join(os.path.split(test_path3)[-1].split('.')[:-1] ), msg+'1, max_gen=%r'%max_gen)
    data = msg + (1024-len(msg) ) * "2"
    with open(test_path3,"wb") as f:
        f.write(data)
    # 2nd try -- should not rotate (original + gen1)
    max_gen = rotate(test_path3,1,3)
    list_files('.'.join(os.path.split(test_path3)[-1].split('.')[:-1] ), msg+'2, max_gen=%r'%max_gen)
    data = msg + (1024-len(msg) ) * "3"
    with open(test_path3,"wb") as f:
        f.write(data)
    # 3rd try -- should rotate (original + gen1 + gen2)
    print("Sleep 5 sec to age the file...")
    time.sleep(5)
    max_gen = rotate(test_path3,1,3)
    list_files('.'.join(os.path.split(test_path3)[-1].split('.')[:-1] ), msg+'3, max_gen=%r'%max_gen)
