#!/usr/bin/python3
# -*- coding: utf8 -*-
""" 基地局アプリバージョン """
BTS_VERSION = "3.0.4"
CHG = """
3.0.3 -> 3.0.4
※ New dev environment
    - Python 3.9
    - Visual Studio 2022 (cna_base.exe and EEMA_core)

2.0.2 -> 3.0.3
※ Python 3 version
※ Multi-language

2.0.2 -> 2.0.3
※ HW エラー発生時に「あり得ないデータ」（vbat の値が負の場合）を残さない
・ コンソールにメッセージを表示
・ evtlog.txt にメッセージを記録
※ data_obje = data_save.saver に key "Versions" 追加

2.0.1 -> 2.0.2
※ TCP 通信失敗の際の RSSI および DevTmp コンソールメッセージ表示失敗対策

2.0.0 -> 2.0.1
※ 2.0.0 改修部分の問題修正

0.0.7 -> 2.0.0
※ conanair V2 対応

0.0.6 -> 0.0.7
0. 不使用ファイルをインストーラーから削除
・ send_ctrlb.exe
・ send_ctrlc.exe
・ send_sigint.exe
・ dist/cna_ctrl_b.exe
・ dist/cna_ctrl_c.exe
・ dist/cna_sigint.exe

1. 変更した点のまとめ (「改修仕様(案)」の解説)
・ 要約 CSV と cna 両方を保存できるようにした
・ 保存ファイルの指定方法を分かり易くした
    - 従来は「FILE_TYPE」と「SUMMARY_CSV」２つの項目がかかわっていた
    - これを「FILE_TYPE」だけで指定できるように変更した
・ 後方互換性のため項目「SUMMARY_CSV」は残す
    - 従来同様、項目「FILE_TYPE」が指定されていない時だけ有効
    - 「SUMMARY_CSV, YES」で要約 CSV だけを保存する
    - ただし「SUMMARY_CSV, YES」の指定があった場合、廃止予定と警告する
・ 「DATA_GEN, 0」を指定した場合、世代管理機能のみ止めるよう変更
    - 従来「DATA_GEN, 0」指定で APP_ROOT との同期処理も止まっていた
・ 「DATA_SYNC, OFF」を指定すると APP_ROOT との同期処理を停止する
    - 後述の通り項目「DATA_SYNC」に同期処理停止の機能は無かった
    - 必須項目だったが任意項目に変更
    - ディフォルトで「同期処理を行う」 (「DATA_SYNC, ON」も可)
    - 後方互換性のため数値での設定も可能にする: ゼロで停止、非ゼロで行う
    - ただし数値で設定の場合、廃止予定と警告する
・ 要約 CSV と両方保存の場合 cna ファイルを +plus_cna フォルダー下に保存
    - 「両方保存」は「要約 CSV に cna を追加」と位置付ける
    - 前項の趣旨を表したフォルダー名にした
    - <Tag>フォルダーと横並びなので Tag名と重複しにくい様「+」で始めた

2. 「改修仕様(案)」保存するファイル形式の指定
項目「FILE_TYPE」に以下の値を指定する (以下保存スペース消費の少ない順)
・ SUMMARY_CSV
    - 要約 CSV を CAIR_ROOT￥data￥<tag> フォルダー内に保存
・ CNA
    - cna ファイルを CAIR_ROOT￥data￥<tag> フォルダー内に保存
・ SUMMARY_CSV+CNA
    - 要約 CSV を CAIR_ROOT￥data￥<tag> フォルダー内に保存
    - cna ファイルを CAIR_ROOT￥data￥+plus_cna￥<tag> フォルダー内に保存
・ CSV (ディフォルト)
    - 生データ付き CSV を CAIR_ROOT￥data￥<tag> フォルダー内に保存

3. 「改修仕様(案)」APP_ROOT とのデータ同期の指定
項目「DATA_SYNC」に以下の値を指定する
・ ON (ディフォルト)
    - CAIR_ROOT￥data￥<tag>￥ と APP_ROOT￥<tag>￥ の内容を同期
    - CAIR_ROOT￥data￥ と APP_ROOT￥ 下の +plus_cna￥<tag>￥ も同期
    - 同期を行う前に次項の世代管理を行う → 同期先の世代も管理される
・ OFF
    - APP_ROOT フォルダー下の測定データは一切管理しない
    - 既に存在する測定データはそのまま残る
・ 数値での設定も可能 (後方互換性のため)
    - 0 (ゼロ) = OFF, ゼロ以外 = ON
    - 数値が指定されたら警告を表示する
    - 『数値指定は廃止予定: ON or OFF に修正すべし』の趣旨

4. 「改修仕様(案)」世代管理の指定
項目「DATA_GEN」にゼロまたは正の整数値を指定する
・ 指定値 = 0 (ゼロ) の場合、世代管理を行わない
    - 測定データファイルが自動的に削除されることは無い
・ 指定値 > 0 の場合、指定された数の最新世代を残すよう管理する
・ 項目「DATA_GEN」を指定した行が無いとエラー (必須項目)

5. 「改修仕様(案)」項目「SUMMARY_CSV」の扱い
当分の間従来同様の使い方を許容するが、同時に警告を表示する
・ 後方互換性のため使用できるようにしておく
・ 許容する従来同様の使い方
    - 「SUMMARY_CSV, YES」で要約 CSV を保存する様に次項の設定を上書修正
    - 項目「FILE_TYPE」が生データ付き CSV を保存する設定の時だけ有効
    - 前項が他の設定の場合「SUMMARY_CSV, YES」は無視して警告表示
・ 表示する警告
    - ↑の無視した場合の警告とは別に (追加で) 表示
    - 「SUMMARY_CSV, YES」が指定されたら常に表示する
    - 『廃止予定:「FILE_TYPE, SUMMARY_CSV」に修正すべし』の趣旨


0.0.5 -> 0.0.6
「予定超過」メッセージを自動的に出すようにした
CAIR_ROOT/private/console.log と CAIR_ROOT/dev_dump/*.txt を logrotate するように変更

0.0.3d -> 0.0.5
data_manage 処理を thread 化 + 同期処理方式変更
  - TCP/IP 通信発生時に動作を一旦停止（通信を優先）
  - CAIR_ROOT 下と APP_ROOT 下に同時保存
  - パラメータ DATA_GEN にゼロ以下の値設定で管理プロセス停止
  - 管理プロセス停止時は APP_ROOT 下にのみ保存（CAIR_ROOT 下に保存しない）
  - パラメータ SCHED30 ENABLE 時（Default値）は毎時 10分台と 40分台に起動を制限
app_root.conf のパラメータ追加
  - SUMMARY_CSV, YES
  - SAVE_ALL, YES
  - CLKCAL_MINUTE, n (0 < n <= 1440)

0.0.3c -> 0.0.3d
エラー情報を、可能な場合はスプール経由で表示する
  - CONLOG パラメータが Yes に設定されていればログに記録される
通信が途中で途切れた場合のエラー防止 Part-III
  - sec_init_msg が初期化されない場合があった

0.0.3b -> 0.0.3c
通信が途中で途切れた場合のエラー防止 Part-II
  - TIMING_DUMP パラメータが Yes に設定されていた場合
  - 初期化されていない clck_adj_raw および clck_adj_dly を参照していた

0.0.3a -> 0.0.3b
通信が途中で途切れた場合のエラー防止
  - TIMING_DUMP パラメータが Yes に設定されていた場合
  - 受信していなくても rtc_mem を参照していた

0.0.3 -> 0.0.3a
.cna (バイナリー) 形式のファイルが正しく書かれていなかったのを修正
自動モードのバッテリー電圧測定方法変更に対応
  - 低電圧閾値を app_root.conf から読み込むようにした
  - 低電圧閾値のディフォルトを 2.55V に設定
  - tdump に新旧両方の測定値を記録
繰り返しスケジュールのバリデーション強化
  - 時間間隔ゼロの場合エラーにする

0.0.2b -> 0.0.3
キー操作および制御ファイルによる設定再読み込み
  - Ctrl+C
  - CAIR_ROOT\reload
前項に伴うコマンドキーの変更
  - 設定再読み込み: なし -> Ctrl+C
  - 再起動: Ctrl+C -> Ctrl+Break

0.0.2a -> 0.0.2b
電池電圧を表示する機会を増加
  - 初期クロック補正時に表示していなかったのを表示するよう変更
データ管理プロセス実行タイミング管理の修正
  - 通信が発生した場合、データを保存していなくても管理プロセスを実施していた
  - 実行時間間隔が DATA_SYNC パラメーター設定値の２倍になっていた

0.0.2 -> 0.0.2a
受信した本体部分のデータ長が不正な場合に例外が発生するのを修正
以下の場合 Graceful に終了:
    Ctrl+Break
    Window 右上 X ボタン
TODO:: 以下の場合も Graceful に終了するには GUI が必要？
    User Logoff
    System Shutdown/Reboot
"""
