#!/usr/bin/python3
# -*- coding: utf8 -*-

# Public modules
# from __future__ import print_function
# try:
    # import Queue            # py2
# except ModuleNotFoundError:
    # import queue as Queue   # py3
import queue as Queue
import socket, select, time, traceback
from contextlib import closing
import codecs,datetime,hashlib,multiprocessing,os,shutil,struct,sys,threading,traceback
import numpy as np
import platform
pltfm = platform.platform().lower()
if pltfm.startswith("windows-10"):
    import ctypes
    kernel32 = ctypes.windll.kernel32
    kernel32.SetConsoleMode(kernel32.GetStdHandle(-11), 7)
if pltfm.startswith("windows-10") or pltfm.startswith("linux"):
    esc_norm = "\x1b[0m"
    esc_strng = "\x1b[101;93m"
    esc_grbg = "\x1b[42;97m"
    esc_blfg = "\x1b[47;94m"
    esc_nega = "\x1b[107;30m"
    esc_neg2 = "\x1b[47;30m"
else:
    esc_norm = ""
    esc_strng = ""
    esc_grbg = ""
    esc_blfg = ""
    esc_nega = ""
    esc_neg2 = ""
PAUSE_CMD = ""
if platform.platform().lower().startswith("windows"):
    import msvcrt,win32api,win32con
    PAUSE_CMD = "pause"
else:
    import linux_getch, atexit


# Private modules
from cna_bts_version import BTS_VERSION
import data_save,conf_parser,cna_logrotate

# Multi-language
import multilang_tools
import ml_cna_base_st
T = multilang_tools.ml_server(ml_cna_base_st.S)

# Set language
def set_app_lang():
    global T
    testfile = os.path.join("CAIR_ROOT","LANG.conf")

    lang = "default"
    if len(sys.argv) > 1:
        lang = sys.argv[1]
    elif os.path.exists(testfile):
        with codecs.open(testfile, "r", encoding='utf-8', errors='backslashreplace') as f:
            lang = f.readline().strip()

    T = multilang_tools.ml_server(ml_cna_base_st.S, lang)
    conf_parser.set_confp_lang(lang)
set_app_lang()

try:
    CNF_PARSER = conf_parser.key_tag_sched()

    VERBOSE = CNF_PARSER.aprt.is_verbose()
    CLK_ADJ_MAX = CNF_PARSER.aprt.get_param("clk_adj_max")              # Upper limit for the Sleep Clock Adjust value
    CLK_ADJ_MIN = CNF_PARSER.aprt.get_param("clk_adj_min")              # Lower limit for the Sleep Clock Adjust value
    USE_INIT_US = CNF_PARSER.aprt.get_param("use_init_us")              # Flag to use startup delay micors, to evaluate as bool
    K_CLK_DLY = CNF_PARSER.aprt.get_param("k_clk_dly")                  # IIR Loop Filter Constant for Clock Frequency
    AWTH_MIN_SEC = CNF_PARSER.aprt.get_param("awth_min_sec")            # Eary aWake paremeter: min limit of the threshold
    AWTH_MAX_SEC = CNF_PARSER.aprt.get_param("awth_max_sec")            # Eary aWake paremeter: max limit of the threshold
    AWTH_INTVL_RATIO = CNF_PARSER.aprt.get_param("awth_intvl_ratio")    # Eary aWake paremeter: threshold / actula interval
    # raise ValueError("No default schedule") # debug
except Exception as e:
    print("\n####\n## Error in parsing config.\n####")
    traceback.print_exc()

    # print(repr(e) )    # debug
    if str(e) == 'No default schedule':
        print(esc_strng + "################################################################################"+esc_norm)
        print(esc_strng + T.m0000 + esc_norm)
        print(esc_strng + T.m0010 + esc_norm)
        print(esc_strng + T.m0020 + esc_norm)
        print(esc_strng + "################################################################################"+esc_norm)
    sys.exit(0)

PARSE_SERIALIZE = True

MIN_SYNC_INTVL_MIN = 3
DATA_DIR = os.path.join("CAIR_ROOT","data")
DATA_DIR_CNA = os.path.join(DATA_DIR,"+plus_cna")
D_DIR_BUSY = False
STOP_DATA_MAN = False
REBOOT_FILE = os.path.join("CAIR_ROOT","reboot")
RELOAD_FILE = os.path.join("CAIR_ROOT","reload")
LISTEN_PORT = 14665
BCAST_PORT = 14665
TX_PORT = 4000

LOG_MAX = 5000
LOG_MIN = 4000

# Debug Switches
DISABLE_CLK_ADJ = False
CONST_INTVL_SEC = 0
TIMING_DUMP = CNF_PARSER.aprt.get_param("tdump")                    # Timing dump switch
TDUMP_DIR = "dev_dump"

def DEBUGPRINT(*args,**kwargs):
    print(*args,**kwargs)

def beep():
    print(chr(7),end="")

def get_ts():
    return time.strftime("%Y-%m-%d %H:%M:%S")

UDP_TCP_STAT = {}
def chk_tcp_threads():
    global UDP_TCP_STAT,D_DIR_BUSY
    while UDP_TCP_STAT:
        if STOP_DATA_MAN:
            D_DIR_BUSY = True
            return  # Abort!
        if VERBOSE and D_DIR_BUSY:
            prt_spooler("** Stop data_manage")
        D_DIR_BUSY = False  # Allow TCP thread to complete
        time.sleep(.1)
        # age UDP_TCP_STAT
        k_to_del = []
        for k in UDP_TCP_STAT.keys():
            if (time.time() - UDP_TCP_STAT[k] ) > 600:  # more than 10 minute
                k_to_del.append(k)
        for k in k_to_del:
            del UDP_TCP_STAT[k]
    if VERBOSE and not D_DIR_BUSY:
        prt_spooler("** Start data_manage")
    D_DIR_BUSY = True
    return

def h_m_s(sec):
    ss = int(sec)
    h = int(ss / 3600)
    m = int(ss / 60) % 60
    s = ss % 60
    if   abs(sec) < 60:
        return "%ds"%s
    elif abs(sec) < 3600:
        return "%dm%3ds"%(m,s)
    return "%dh%3dm%3ds"%(h,m,s)

approot_timer = 0
def data_manage(cna,app,gen,file_type,sync=True):
    # "cna csv summary_csv summary_csv+cna".split()
    if file_type in "csv summary_csv".split():
        ext_list = ["csv",]
    elif file_type == "cna":
        ext_list = ["cna",]
    else:
        ext_list = ["csv","cna"]
    for n,i in enumerate(ext_list):
        try:
            data_manage_sub(cna,app,gen,i,sync,"+plus_cna" if n else None)
        except Exception as e:
            my_raise(e)
def data_manage_sub(cna,app,gen,ext,sync,extra=None):
    global D_DIR_BUSY,_error_in_thread

    if D_DIR_BUSY:
        put_log(T.m0030)
        prt_spooler(esc_strng+time.strftime("# %Y-%m-%d %H:%M:%S")+
                T.m0040+ esc_norm
                                                                )
        return

    prt_spooler(
                    esc_grbg
                    +time.strftime("# %Y-%m-%d %H:%M:%S")
                    +T.m0050
                    +(" ("+extra+")" if extra is not None else "")
                    + esc_norm
                )
    manage_start = time.time()

    da_dir = cna if extra is None else os.path.join(cna,extra)
    ext_l = "." + ext.lower()
    all_tags = [i[1] for i in CNF_PARSER.tags.items() ]
    try:
        src_dirs = [i for i in os.listdir(da_dir) if os.path.isdir(os.path.join(da_dir,i) ) and i in all_tags]
    except (IOError,WindowsError) as e:
        put_log("No src dir (%r)"%e)
        prt_spooler("No src dir (%r)"%e)
        return

    # Lock CAIR_ROOT/data
    D_DIR_BUSY = True

    src_dirs.sort()
    file_num1 = 0
    file_num2 = 0
    file_num3 = 0
    total_num = len(src_dirs)
    for num,d in enumerate(src_dirs):
        chk_tcp_threads()       # wait if TCP threads running
        if STOP_DATA_MAN: break # Abort!

        # CWD
        dir = os.path.abspath(os.path.join(da_dir,d) )
        # list of files in CWD
        all_files = [i for i in os.listdir(dir) if os.path.isfile(os.path.join(dir,i) ) ]
        all_files.sort()

        # Remove files with foreign extentions
        temp_files = list(all_files)    # make copy
        for i in [i for i in temp_files if not i.lower().endswith(ext_l) ]:
            os.remove(os.path.join(dir,i) )
            all_files.remove(i)
        file_n1 = len(all_files)

        chk_tcp_threads()       # wait if TCP threads running
        if STOP_DATA_MAN: break # Abort!

        # Obtain list of target files
        files = list(all_files) # make copy
        files.sort()

        # Manage generation in src
        if gen > 0 and len(files) > gen:
            for i in files[:len(files) - gen]: 
                try:
                    os.remove(os.path.join(dir,i) )
                    all_files.remove(i)
                except IOError as e:
                    put_log(str(e) )
                    prt_spooler(str(e) )
                    pass
        file_n2 = len(all_files)

        chk_tcp_threads()       # wait if TCP threads running
        if STOP_DATA_MAN: break # Abort!

        # Dest dir
        ddir = os.path.join(app if extra is None else os.path.join(app,extra),d)
        if not os.path.exists(ddir): os.makedirs(ddir)

        if sync and gen > 0:
            # Manage generation in dst
            dfiles = [i for i in os.listdir(ddir) if i.lower().endswith(ext_l) and os.path.isfile(os.path.join(ddir,i) ) ]
            tfiles = [i.lower() for i in all_files]
            for i in dfiles:
                if i.lower() not in tfiles:
                    try:
                        os.remove(os.path.join(ddir,i) )
                    except IOError as e:
                        put_log("Ignored: %s"%str(e) )
                        prt_spooler("Ignored: %s"%str(e) )

        chk_tcp_threads()       # wait if TCP threads running
        if STOP_DATA_MAN: break # Abort!

        # Copy different files
        file_n3 = 0
        if sync:
            for i in all_files:
                chk_tcp_threads()       # wait if TCP threads running
                if STOP_DATA_MAN: break # Abort!

                src = os.path.join(dir,i)
                dst = os.path.join(ddir,i)
                try:
                    ###
                    ### Compare contents
                    ###
                    # with open(src, "rb") as s:
                        # sdata = s.read()
                    # try:
                        # with open(dst, "rb") as u:
                            # ddata = u.read()
                    # except IOError as e:
                        # if e.args[0] == 2:
                            # ddata = None
                        # else: raise
                    # if ddata != sdata:
                        # with open(dst, "wb") as u:
                            # u.write(sdata)  # copy content
                        # file_n3 += 1
                        # time.sleep(0.01)    # Allow other threads to use CPU
                    ###
                    ### Compare attributes
                    ###
                    s_stat = os.stat(src)
                    try:
                        d_stat = os.stat(dst)
                    except OSError as e:
                        if e.args[0] == 2:
                            d_stat = None
                        else: raise
                    if d_stat is None:
                        not_exist = True
                        cond_size = None
                        cond_time = None
                    else:
                        not_exist = False                                   # dst not exists
                        cond_size = s_stat.st_size != d_stat.st_size        # different size
                        abs_delta = abs(s_stat.st_mtime - d_stat.st_mtime)
                        cond_time = abs_delta > 5e-3                        # abs(delta(last modfy times) ) > 5ms
                    if not_exist or cond_size or cond_time:
                        if VERBOSE:
                            def sd_test():
                                if not_exist:
                                    o = "dst not exists"
                                else:
                                    o = "size %r/%r (%s), mtime %.3f/%.3f (abs_delta: %.3f)" % (
                                        s_stat.st_size,d_stat.st_size,
                                        "different" if cond_size else "same",
                                        s_stat.st_mtime,d_stat.st_mtime,abs_delta,
                                    )
                                return o
                            prt_spooler("### copy@data\manage: %s -> %s"%(src,dst) )
                            prt_spooler("###      "+sd_test() )
                        shutil.copy2(src, dst)  # copy file (including metadta)
                        file_n3 += 1
                        # time.sleep(0.01)    # Allow other threads to use CPU
                except IOError as e:
                    put_log("Ignored: %s"%str(e) )
                    prt_spooler("Ignored: %s"%str(e) )
        file_num1 += file_n1
        file_num2 += file_n2
        file_num3 += file_n3
        if VERBOSE:
            prt_spooler("#### data_manage[%03d/%03d]@%-20s%d->%d/%d"%(num+1,total_num,d,file_n1,file_n2,file_n3) )
        time.sleep(0.01)    # Allow other threads to use CPU

    # Release CAIR_ROOT/data
    D_DIR_BUSY = False

    elapsed = time.time() - manage_start

    # prt_spooler(esc_grbg+time.strftime("# %Y-%m-%d %H:%M:%S Data Manage Process Done")+esc_norm)
    prt_spooler(esc_grbg+time.strftime(
            "# %Y-%m-%d %H:%M:%S")+
            T.m0060%(
                                                                file_num1,
                                                                file_num2,
                                                                file_num3,
                                                                elapsed
                                                                )
                                                            + esc_norm
                                                            )

# typedef struct deepsleep_param {
    # uint32_t	hrs;
    # uint32_t	us_hr;
    # uint32_t	usecs;
# } deepsleep_param_t;
# typedef struct packet_stats {
    # uint32_t	ok_cnt;
    # uint32_t	ng_cnt;
    # uint32_t	last_ok_seq;
    # uint32_t	last_ng_seq;
# } packet_stats_t;
# typedef struct rtc_mem_s {
    # uint32_t	ip_pack_seq;			// 4/4
    # uint32_t	sleep_hr_count;			// 4/8
    # packet_stats_t wifi_stats;			// 16/24
    # packet_stats_t udp_stats;			// 16/40
    # packet_stats_t tcp_stats;			// 16/56
    # deepsleep_param_t	tgt_ds_param;	// 12/68
    # deepsleep_param_t	def_ds_param;	// 12/80
    # uint8_t		raw_time[8];			// for double  8/88
    # uint32_t	no_comm_cnt;			// 4/92
    # uint32_t	init_contct_done;		// 4/96
    # uint32_t	final_sleep;			// 4/100
    # uint32_t	init_fail;				// 4/104
    # deepsleep_param_t	cur_ds_param;	// 12/116
    # uint32_t	dummy;					// 4/120
    # uint8_t		last_time[8];			// for double  8/128
    # uint8_t		clck_adj0[8];			// for double  8/136
    # uint8_t		clck_adj[8];			// for double  8/144
    # uint32_t	prev_comm_fail;			// 4/148
    # uint32_t	initial_us;				// 4/152
    # uint32_t	use_init_us;			// 4/156
    # uint32_t	tadj_init;			    // 4/160
    # uint8_t		time_adj[8];			// for double  8/168
    # uint8_t		old_vdd3v3[8];			// for double  8/176
# } rtc_mem_s_t;
RTC_MEM_SIZE =  512
RTC_USED_SIZE = 176
RTC_USED_SIZE += (2*4 + 2*8)  # conanair V2
class rtc_mem_decode(object):
    def __init__(self, buf):
        _dict = {}
        _fmt_ds_param = "III"
        _fmt_pack_stat = "IIII"
        self._fmt_rtc_mem = "II" + 3*_fmt_pack_stat + 2*_fmt_ds_param + "dIIII" + _fmt_ds_param + "IdddIIIIdd"
        self._fmt_rtc_mem += "IIdd"  # conanair V2 -- run_state, ssi & temperature
        unpk = struct.unpack(self._fmt_rtc_mem, buf[:RTC_USED_SIZE] )
        _dict["ip_pack_seq"] = unpk[0]          # I "II" -- 2019-05-30 not in use
        _dict["sleep_hr_count"] = unpk[1]       # I -- 2019-05-30 not in use
        _dict["wifi.ok_cnt"] = unpk[2]          # I 3*"IIII" 1/3 -- 2019-05-30 VERBOSE only
        _dict["wifi.ng_cnt"] = unpk[3]          # I -- 2019-05-30 VERBOSE only
        _dict["wifi.last_ok_seq"] = unpk[4]     # I -- 2019-05-30 VERBOSE only
        _dict["wifi.last_ng_seq"] = unpk[5]     # I -- 2019-05-30 VERBOSE only
        _dict["udp.ok_cnt"] = unpk[6]           # I 3*"IIII" 2/3 -- 2019-05-30 VERBOSE only
        _dict["udp.ng_cnt"] = unpk[7]           # I -- 2019-05-30 VERBOSE only
        _dict["udp.last_ok_seq"] = unpk[8]      # I -- 2019-05-30 VERBOSE only
        _dict["udp.last_ng_seq"] = unpk[9]      # I -- 2019-05-30 VERBOSE only
        _dict["tcp.ok_cnt"] = unpk[10]          # I 3*"IIII" 3/3 -- 2019-05-30 VERBOSE only
        _dict["tcp.ng_cnt"] = unpk[11]          # I -- 2019-05-30 VERBOSE only
        _dict["tcp.last_ok_seq"] = unpk[12]     # I -- 2019-05-30 VERBOSE only
        _dict["tcp.last_ng_seq"] = unpk[13]     # I -- 2019-05-30 VERBOSE only
        _dict["tgt.hrs"] = unpk[14]             # I 2*"III" 1/2
        _dict["tgt.us_hr"] = unpk[15]           # I
        _dict["tgt.usecs"] = unpk[16]           # I
        _dict["def.hrs"] = unpk[17]             # I 2*"III" 1/2
        _dict["def.us_hr"] = unpk[18]           # I
        _dict["def.usecs"] = unpk[19]           # I
        _dict["raw_time"] = unpk[20]            # d "dIIII"
        _dict["no_comm_cnt"] = unpk[21]         # I -- 2019-05-30 not in use (just assigned)
        _dict["init_contct_done"] = unpk[22]    # I
        _dict["final_sleep"] = unpk[23]         # I -- 2019-05-30 not in use
        _dict["init_fail"] = unpk[24]           # I -- 2019-05-30 not in use
        _dict["cur.hrs"] = unpk[25]             # I "III"
        _dict["cur.us_hr"] = unpk[26]           # I
        _dict["cur.usecs"] = unpk[27]           # I
        _dict["dummy"] = unpk[28]               # I "IdddIIIId" -- 2019-05-30 not in use
        _dict["last_time"] = unpk[29]           # d
        _dict["clck_adj0"] = unpk[30]           # d
        _dict["clck_adj"] = unpk[31]            # d
        _dict["prev_comm_fail"] = unpk[32]      # I
        _dict["initial_us"] = unpk[33]          # I -- 2019-05-30 VERBOSE only
        _dict["use_init_us"] = unpk[34]         # I
        _dict["tadj_init"] = unpk[35]           # I
        _dict["time_adj"] = unpk[36]            # d -- 2019-05-30 not in use
        _dict["old_vdd3v3"] = unpk[37]          # d -- 2019-05-30 VERBOSE only
        _dict["run_state"] = unpk[38]           # I -- conanair V2
        _dict["pad_run_state"] = unpk[39]       # I -- conanair V2
        _dict["AP_RSSI"] = unpk[40]             # d -- conanair V2
        _dict["Dev_Tmp"] = unpk[41]             # d -- conanair V2
        self._dict = _dict
    def get(self, key):
        return self._dict.get(key)
    def set(self, key, val):
        if key not in self._dict.keys():
            raise ValueError("Invalid key %s"%key)
        self._dict[key] = val
    def pack(self):
        _dict = self._dict
        unpk = []
        unpk.append(_dict["ip_pack_seq"] )      # unpk[0]
        unpk.append(_dict["sleep_hr_count"] )   # unpk[1]
        unpk.append(_dict["wifi.ok_cnt"] )      # unpk[2]
        unpk.append(_dict["wifi.ng_cnt"] )      # unpk[3]
        unpk.append(_dict["wifi.last_ok_seq"] ) # unpk[4]
        unpk.append(_dict["wifi.last_ng_seq"] ) # unpk[5]
        unpk.append(_dict["udp.ok_cnt"] )       # unpk[6]
        unpk.append(_dict["udp.ng_cnt"] )       # unpk[7]
        unpk.append(_dict["udp.last_ok_seq"] )  # unpk[8]
        unpk.append(_dict["udp.last_ng_seq"] )  # unpk[9]
        unpk.append(_dict["tcp.ok_cnt"] )       # unpk[10]
        unpk.append(_dict["tcp.ng_cnt"] )       # unpk[11]
        unpk.append(_dict["tcp.last_ok_seq"] )  # unpk[12]
        unpk.append(_dict["tcp.last_ng_seq"] )  # unpk[13]
        unpk.append(_dict["tgt.hrs"] )          # unpk[14]
        unpk.append(_dict["tgt.us_hr"] )        # unpk[15]
        unpk.append(_dict["tgt.usecs"] )        # unpk[16]
        unpk.append(_dict["def.hrs"] )          # unpk[17]
        unpk.append(_dict["def.us_hr"] )        # unpk[18]
        unpk.append(_dict["def.usecs"] )        # unpk[19]
        unpk.append(_dict["raw_time"] )         # unpk[20]
        unpk.append(_dict["no_comm_cnt"] )      # unpk[21]
        unpk.append(_dict["init_contct_done"] ) # unpk[22]
        unpk.append(_dict["final_sleep"] )      # unpk[23]
        unpk.append(_dict["init_fail"] )        # unpk[24]
        unpk.append(_dict["cur.hrs"] )          # unpk[25]
        unpk.append(_dict["cur.us_hr"] )        # unpk[26]
        unpk.append(_dict["cur.usecs"] )        # unpk[27]
        unpk.append(_dict["dummy"] )            # unpk[28]
        unpk.append(_dict["last_time"] )        # unpk[29]
        unpk.append(_dict["clck_adj0"] )        # unpk[30]
        unpk.append(_dict["clck_adj"] )         # unpk[31]
        unpk.append(_dict["prev_comm_fail"] )   # unpk[32]
        unpk.append(_dict["initial_us"] )       # unpk[33]
        unpk.append(_dict["use_init_us"] )      # unpk[34]
        unpk.append(_dict["tadj_init"] )        # unpk[35]
        unpk.append(_dict["time_adj"] )         # unpk[36]
        unpk.append(_dict["old_vdd3v3"] )       # unpk[37]
        unpk.append(_dict["run_state"] )        # unpk[38] -- conanair V2
        unpk.append(_dict["pad_run_state"] )    # unpk[39] -- conanair V2
        unpk.append(_dict["AP_RSSI"] )          # unpk[40] -- conanair V2
        unpk.append(_dict["Dev_Tmp"] )          # unpk[41] -- conanair V2
        return struct.pack(self._fmt_rtc_mem, *unpk)

def ts_w_ms():
    t = time.time()
    ms = t % 1
    return time.strftime("%H:%M:%S.%%03d",time.localtime(t) )%int(round(1e3*ms) )

BUFSIZE = 4096
PRT_LOCK = threading.Lock()
PRT_Q = Queue.Queue()
DEQ_PAUSE = False
LOG_LOCK = threading.Lock()
LOG_Q = Queue.Queue()
_FILE_SAVED = False
_LAST_TCP_END = 0

def read_socket(s, addr, d_savers, prev_thread):
    try:
        read_socket_sub(s, addr, d_savers, prev_thread)
    except Exception as e:
        my_raise(e)

def read_socket_sub(s, addr, d_savers, prev_thread):
    global _FILE_SAVED, _LAST_TCP_END
    def local_log(msg):
        local_id = ""
        local_tag = "Unknown"
        try:
            local_id = "("+ca_id+")"
        except NameError:
            pass
        except UnboundLocalError:
            pass
        try:
            local_tag = tagname
        except NameError:
            pass
        except UnboundLocalError:
            pass
        wk = local_tag + local_id+": "+msg
        put_log(wk)

    th_start = ts_w_ms()

    data_obje = data_save.saver()
    local_ts = time.time()
    save_data = True
    save_all = CNF_PARSER.aprt.get_param("save_all")
    data_ok = False
    rtc_mem = None
    data_len = None
    all_data = None
    str_lts = "n/a"
    str_sts = "n/a"
    msg = ""
    tagname = "None"
    ca_id = "unknown"
    ip = addr[0] if addr is not None else "unknown"
    sample_ts = 0       # Start of this sampling
    last_ts = 0         # Start of previous sampling
    sess_time_sec = 0   # time.time() - sample_ts
    vbat = 0.0
    clck_adj_raw = 1.0
    clck_adj_dly = 1.0
    sec_init_msg = ""
    time_diff = 0.0
    time_diff_sent = False

    # 2020-12-26 Initialize variables to be used in the newly added message
    str_scd_now = "unknown"

    while True:
        try:
            data = s.recv(BUFSIZE)
        except socket.timeout as e:
            # wk = ca_id+" ("+ip+"): TCP timed-out"
            wk = ca_id+" ("+ip+T.m0070
            local_log(wk)
            msg += (esc_strng+"!!\x07 "+wk+esc_norm+"\n")
            data = ""
        except socket.error as e:
            err = e.args[0]
            if err in [10053,10054,10060]:
                                        # 10053 = 確立された接続がホスト コンピューターのソウトウェアによって中止されました。
                                        # 10054 = disconnected by remote peer,
                                        # 10060 = 接続済みの呼び出し先が一定の時間を過ぎても正しく応答しなかったため、
                                        #         接続できませんでした。または接続済みのホストが応答しなかったため、
                                        #         確立された接続は失敗しました。
                # wk = ca_id+" ("+ip+"): Disconn. by remote peer"
                wk = ca_id+" ("+ip+T.m0120
                local_log(wk)
                msg += (esc_strng+"!!\x07 "+wk+esc_norm+"\n")
                data = ""
            else:
                raise
        if data:
            ll = len(data)

            # typedef struct tcp_auth {
                # char id[16];
                # uint32_t cnonce;
                # char hash[16];
                # uint32_t nonce;
            # } tcp_auth_t;
            if   ll == 40:  # sizeof(tcp_auth_t)
                # Send Base Station Cert
                ca_id = data[:16].split(b'\x00')[0].decode()
                tagname = CNF_PARSER.get_tag(ca_id)
                if tagname is None:
                    raise ValueError("No tagname available for %s"%ca_id)

                key = CNF_PARSER.get_key(ca_id)
                if key is None:
                    # wk = ca_id+" ("+ip+"): conanair does not have valid key"
                    wk = ca_id+" ("+ip+T.m0140
                    local_log(wk)
                    msg += (esc_strng+"!!\x07 "+wk+esc_norm+"\n")
                    break
                cnonce = os.urandom(4)
                nonce  = os.urandom(4)  # nonce to send
                hash = hashlib.md5(data[:16]+data[36:40]+cnonce+key[:32] ).digest() # id + received nonce + cnonce + key
                data = data[:16] + cnonce + hash + nonce
                s.send(data)
                data_len = None

            elif ll == 552: # TCP Auth & Schedule: sizeof(tcp_auth_t) + sizeof(rtc_mem) == 40 + 512
                # Authenticate conanair
                ca_id = data[:16].split(b'\x00')[0].decode()
                tagname = CNF_PARSER.get_tag(ca_id)
                if tagname is None:
                    raise ValueError("No tagname available for %s"%ca_id)

                key = CNF_PARSER.get_key(ca_id)
                if key is None:
                    # wk = ca_id+" ("+ip+"): conanair does not have valid key"
                    wk = ca_id+" ("+ip+T.m0140
                    local_log(wk)
                    msg += (esc_strng+"!!\x07 "+wk+esc_norm+"\n")
                    break
                c_hash = hashlib.md5(data[:16]+nonce+data[16:20]+key[:32] ).digest() # id + local nonce + received cnonce + key
                # msg += "Calculated hash: "+"".join(["%02x"%ord(i) for i in c_hash] )+"\n"
                # msg += "Received hash:   "+"".join(["%02x"%ord(i) for i in data[20:36]] )+"\n"
                if c_hash != data[20:36]:
                    # wk = ca_id+" ("+ip+"): Authentication fail."
                    wk = ca_id+" ("+ip+T.m0150
                    local_log(wk)
                    msg += (esc_strng+"!!\x07 "+wk+esc_norm+"\n")
                    break

                # rtc memory
                buf = data[40:]
                rtc_mem = rtc_mem_decode(buf)
                test = rtc_mem.pack()
                if buf[:RTC_USED_SIZE] != test:
                    raise ValueError("Pack/unpack")

                sample_ts = rtc_mem.get("raw_time") # Start of this sampling
                last_ts = rtc_mem.get("last_time")  # Start of previous sampling
                rtc_clk_adj = max(CLK_ADJ_MIN, min(CLK_ADJ_MAX, rtc_mem.get("clck_adj") ) )
                no_comm_cnt = rtc_mem.get("no_comm_cnt")

                # Next schedule
                sched_now,sched_next = CNF_PARSER.get_sched_by_id(ca_id,sample_ts)
                str_sample_ts = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime(sample_ts) )
                str_scd_now = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime(sched_now) )
                str_scd_nxt = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime(sched_next) )
                time_diff = sched_now - sample_ts

                rtc_mem.set("use_init_us",USE_INIT_US)
                if VERBOSE: msg += (tagname + " = " + ca_id+" ("+ip+"): "
                                + "initial_us: %d, use_init_us: %d\n"
                                %(rtc_mem.get("initial_us"),rtc_mem.get("use_init_us") ) )

                # Calculate actual interval
                act_intvl = sample_ts - last_ts

                # clck_adj_raw = 1.0
                # clck_adj_dly = 1.0

                # Signal initial contact done to conanair
                rtc_mem.set("init_contct_done",1)

                if CNF_PARSER.is_cont_by_id(ca_id)[0]:  # Check for continuous mode
                    # Minimum Interval
                    rtc_mem.set("clck_adj",1.0)
                    rtc_mem.set("tgt.hrs",0)
                    rtc_mem.set("tgt.us_hr",60*60*1000*1000)    # 3600s/hr
                    rtc_mem.set("tgt.usecs",0)  # Firmware will secure the minimum sleep time
                    rtc_mem.set("cur.hrs",0)
                    rtc_mem.set("cur.us_hr",60*60*1000*1000)    # 3600s/hr
                    rtc_mem.set("cur.usecs",0)  # Firmware will secure the minimum sleep time

                    msg += esc_blfg+time.strftime("%Y-%m-%d %H:%M:%S")+"     *** Continuous mode"+esc_norm+"  "

                elif CONST_INTVL_SEC:   # Constant interval test
                    # Specified seconds
                    const_hrs = int(CONST_INTVL_SEC/3600)
                    const_us =  int(CONST_INTVL_SEC%3600) *1000*1000
                    rtc_mem.set("clck_adj",1.0)
                    rtc_mem.set("tgt.hrs",const_hrs)
                    rtc_mem.set("tgt.us_hr",60*60*1000*1000)    # 3600s/hr
                    rtc_mem.set("tgt.usecs",const_us)
                    rtc_mem.set("cur.hrs",const_hrs)
                    rtc_mem.set("cur.us_hr",60*60*1000*1000)    # 3600s/hr
                    rtc_mem.set("cur.usecs",const_us)

                    wk = "*** Constant Interval %d min"%CONST_INTVL_SEC
                    msg += time.strftime("%Y-%m-%d %H:%M:%S")+"\t\t "+wk+"\n"

                elif last_ts == 0 or rtc_clk_adj == 0:  # Initial Clock Adjust
                    # Prevent consuminig data generation
                    save_data = save_all    # do not save data if not save_all,
                    rtc_mem.set("clck_adj0",0.0)    # Signal require 2nd initial

                    # Sleep time
                    t_sleep_temp = 60.0 * CNF_PARSER.aprt.get_param("clkcal_minute")
                    next_hrs = int(np.floor(t_sleep_temp / 3600) )
                    next_us  = int(1e6*np.mod(t_sleep_temp, 3600) )
                    if VERBOSE: msg += "next_hrs=%d, next_us=%d\n"%(next_hrs,next_us)

                    rtc_mem.set("tgt.hrs",next_hrs)
                    rtc_mem.set("tgt.us_hr",60*60*1000*1000)    # 3600s/hr
                    rtc_mem.set("tgt.usecs",next_us)
                    rtc_mem.set("cur.hrs",next_hrs)
                    rtc_mem.set("cur.us_hr",60*60*1000*1000)    # 3600s/hr
                    rtc_mem.set("cur.usecs",next_us)

                    # Initialize default schedule
                    rtc_mem.set("def.hrs",23)
                    rtc_mem.set("def.us_hr",60*60*1000*1000)    # 3600s/hr
                    rtc_mem.set("def.usecs",60*60*1000*1000)    # 23 + 1 = 24hr

                    wk = "*** Starting initial clock adjustment"
                    msg += time.strftime("%Y-%m-%d %H:%M:%S")+"\t\t "+wk+"\n"
                    local_log(wk)
                    if VERBOSE:
                        msg += "sched_now=%s, sched_next=%s\n"%(str_scd_now,str_scd_nxt)

                    # time_diff = 0.0
                    rtc_mem.set("clck_adj",1.0)
                    rtc_mem.set("tadj_init",0)

                else:   # Normal measurements
                    # Previous interval set value
                    sched_intvl = 1e-6 * rtc_mem.get("cur.us_hr")   # calculate secs / hour
                    sched_intvl *= rtc_mem.get("cur.hrs")           # hours in sec
                    sched_intvl += 1e-6 * rtc_mem.get("cur.usecs")  # add secs

                    # Early awake limit
                    aw_limit = max(AWTH_MIN_SEC, min(AWTH_MAX_SEC, AWTH_INTVL_RATIO*act_intvl) )

                    # Early awake test
                    aw_event = time_diff > aw_limit

                    # Short repeat test
                    last_recv,last_sched = CNF_PARSER.get_lasttt_by_tag(tagname)
                    sr_event = sched_now == last_sched

                    prev_fail = rtc_mem.get("prev_comm_fail")
                    # Check previous overdue measurements
                    dsec = CNF_PARSER.get_overdue_by_tag(tagname)
                    if dsec is not None and dsec > 180 and rtc_mem.get("clck_adj0") != 0.0:
                        wk = T.m0160+h_m_s(dsec)
                        local_log(wk)
                        prt_spooler(esc_strng+"!!\x07 "+time.strftime("%Y-%m-%d %H:%M:%S ")+tagname+"("+ca_id+"): "+wk+esc_norm+"\n")
                    # Check previous communication failures
                    if prev_fail:
                        # wk = "previous communication failure detected (%d)"%prev_fail
                        wk = T.m0170%prev_fail
                        local_log(wk)
                        msg += (esc_strng+"!!\x07 "+tagname+"("+ca_id+"): "+wk+esc_norm+"\n")

                    clck_adj = rtc_mem.get("clck_adj")  # Initialize with previous value
                    clck_adj_dly = clck_adj             # Set same value

                    if DISABLE_CLK_ADJ:
                        clck_adj_raw = 1.0
                    else:
                        # clock adjust = total schedule interval / actual interval
                        #              = (failed count + 1) * unit schedule interval / actual interval
                        clck_adj_raw = sched_intvl * (prev_fail + 1) / act_intvl

                    # Test clock adjust out-of-range
                    ca_over = False
                    if clck_adj_raw > CLK_ADJ_MAX or clck_adj_raw < CLK_ADJ_MIN:
                        ca_over = True
                        # wk = "Calculated clck_adj %f is outside of limits, this value will be ignored"%clck_adj_raw
                        wk = T.m0180%clck_adj_raw
                        clck_adj_raw = min(max(CLK_ADJ_MIN, clck_adj_raw), CLK_ADJ_MAX)
                        local_log(wk)
                        if (not aw_event) and (not sr_event):
                            msg += (esc_strng+"!!\x07 "+tagname+"("+ca_id+"): "+wk+esc_norm+"\n")

                    if rtc_mem.get("clck_adj0") == 0.0:
                        # Secondary Initialization
                        save_data = save_all    # do not save data if not save_all,
                        rtc_mem.set("clck_adj0",1.0)
                        sec_init_msg = "2nd.Init"

                        # Old staff
                        # sched_init_done = False
                        # rtc_mem.set("time_adj",0.0)
                        # rtc_mem.set("tadj_init",1)
                        # Initialize Loop Filter -- use 1.0 if calculated value seems not good
                        if ca_over:
                            clck_adj_dly = 1.0
                            local_log("clck_adj initialized with 1.0")
                        else:
                            clck_adj_dly = clck_adj_raw
                    else:
                        # sched_init_done = True
                        if not ca_over:
                            # IIR Loop Filter
                            if K_CLK_DLY > 0.0 and K_CLK_DLY < 1.0:
                                clck_adj_dly = (1.0 - K_CLK_DLY) * clck_adj + K_CLK_DLY * clck_adj_raw
                            else:
                                clck_adj_dly = clck_adj_raw

                    # clock adjust handling
                    rtc_mem.set("clck_adj0",clck_adj_raw)   # Keep raw value
                    clck_adj = clck_adj_dly                 # Restore filtered value
                    rtc_mem.set("clck_adj",clck_adj)        # Keep adjustment value

                    if VERBOSE:
                        msg += "sched_now=%s, sched_next=%s,"%(str_scd_now,str_scd_nxt)
                        msg += " ** clck_adj = %f, clck_adj_raw = %f\n"%(clck_adj,clck_adj_raw)
                    else:
                        msg += "$$ TCP: "+tagname+"(ID="+ca_id+") now=%s, next=%s, "%(str_scd_now,str_scd_nxt)

                    # Early awake and short repeat proc
                    if aw_event:
                        local_log("Eary awake %s - %s > %.3f [s]"%(str_scd_now,str_sample_ts,aw_limit) )
                        save_data = save_all    # if not save_all, do not save now, new data will come soon!
                        next_intvl_sec = sched_now - sample_ts
                    elif sr_event:
                        local_log("Short repeat for the schedule %s"%str_scd_now)
                        save_data = save_all    # if not save_all, do not save now, new data will come soon!
                        next_intvl_sec = sched_next - sample_ts
                    else:
                        next_intvl_sec = sched_next - sample_ts

                    if VERBOSE: msg += "next_intvl_sec=%f,"%next_intvl_sec

                    adjusted_intvl = clck_adj * next_intvl_sec
                    # adjusted_intvl = next_intvl_sec
                    if VERBOSE: msg += "adjusted_intvl=%f,"%adjusted_intvl

                    next_hrs = int(np.floor(adjusted_intvl / 3600) )
                    next_us  = int(1e6*np.mod(adjusted_intvl, 3600) )
                    if VERBOSE: msg += "next_hrs=%d, next_us=%d\n"%(next_hrs,next_us)
                    rtc_mem.set("tgt.hrs",next_hrs)
                    rtc_mem.set("tgt.us_hr",60*60*1000*1000)    # 3600s/hr
                    rtc_mem.set("tgt.usecs",next_us)
                    rtc_mem.set("cur.hrs",next_hrs)
                    rtc_mem.set("cur.us_hr",60*60*1000*1000)    # 3600s/hr
                    rtc_mem.set("cur.usecs",next_us)

                rtc_mem.set("last_time",sample_ts)
                s.send(
                        rtc_mem.pack()          # pack() returns used region only
                        + buf[RTC_USED_SIZE:]   # padding to make the full datasize to RTC_MEM_SIZE=512
                        )

                # str_sts = time.strftime(" (%Y-%m-%d %H:%M:%S)", time.localtime(sample_ts) )
                str_sts = time.strftime("%H:%M:%S", time.localtime(sample_ts) )
                str_lts = time.strftime("%H:%M:%S", time.localtime(last_ts) )
                data_obje.set_identity(ca_id,sample_ts)

            else:   # Receive Body of the Data
                if data_len is None:
                    data_len = ll
                    all_data = data
                else:
                    data_len += ll
                    all_data += data
        else:
            break;

    s.close()
    sess_time_sec = time.time() - sample_ts

    if VERBOSE:
        msg += (str_lts+" / "+str_sts+" / "
                +time.strftime("%H:%M:%S ",time.localtime(local_ts) )
                +"Connection from ")
        if addr is not None:
            msg += "%-23s"%(addr[0]+":"+str(addr[1] )+"; ")
        else:
            msg += "unknown; "

    if data_len == 128448:  # RAW_DATA + DBL_DATA = 128000 + (512 - 64) = 128448
                            # note that 64 is the size of text area used in the manual mode
        data_ok = True
        if VERBOSE:
            msg += "Received %d byte; "%data_len
    else:
        wk = "Received %r byte (!=128448) of data; "%data_len
        local_log(wk)
        msg += wk
        prt_spooler(esc_strng+"!! "+wk+esc_norm)
        if not VERBOSE: msg += "\n"
        save_data = False   # Don't save incomplete data

    if VERBOSE:
        msg += " disconnected.\n"
        if rtc_mem is not None:
            msg += ("  OK cnt/seq,NG cnt/seq: WiFi(%d/%d,%d/%d),UDP(%d/%d,%d/%d),TCP(%d/%d,%d/%d) "
                      %(rtc_mem.get("wifi.ok_cnt"),rtc_mem.get("wifi.last_ok_seq"),
                        rtc_mem.get("wifi.ng_cnt"),rtc_mem.get("wifi.last_ng_seq"),
                        rtc_mem.get("udp.ok_cnt"),rtc_mem.get("udp.last_ok_seq"),
                        rtc_mem.get("udp.ng_cnt"),rtc_mem.get("udp.last_ng_seq"),
                        rtc_mem.get("tcp.ok_cnt"),rtc_mem.get("tcp.last_ok_seq"),
                        rtc_mem.get("tcp.ng_cnt"),rtc_mem.get("tcp.last_ng_seq")
                      ) )

    if data_ok:
        data_obje.set_data(all_data)
        vbat = data_obje.dbldata[0]
        ver_nums = data_obje.dbldata[51]
        if vbat < 0:            # "impossible data"
            save_data = False   # don't save it!

        # OK?, go!
        if save_data:
            # Wait until previous thread completes
            while prev_thread in [i.name for i in threading.enumerate() if i.name.startswith("TCP-") ] and PARSE_SERIALIZE:
                time.sleep(0.1)

            data_proc_start = time.time()
            # parse data according to the output file type
            ### all_file_types = "cna csv summary_csv summary_csv+cna".split()
            if CNF_PARSER.aprt.get_effective_file_type() in "csv summary_csv summary_csv+cna".split():
                d_savers.append(data_obje)
                id,file_name,data = data_obje.main(summary=CNF_PARSER.aprt.get_effective_file_type().startswith("summary_csv") )
                d_savers.remove(data_obje)
            else:   # CNF_PARSER.aprt.get_effective_file_type() == "cna"
                id = data_obje.ID
                data = id.encode() + (10 - len(id) ) * b"\x00"
                file_name = '.'.join(data_obje.FileName.split(".")[:-1] ) + ".cna"
                data += file_name.encode() + (54 - len(file_name) ) * b"\x00"
                data += all_data
            # additional data for summary_csv+cna
            if CNF_PARSER.aprt.get_effective_file_type() == "summary_csv+cna":
                cna_id = data_obje.ID
                cna_data = cna_id.encode() + (10 - len(cna_id) ) * b"\x00"
                cna_file_name = '.'.join(data_obje.FileName.split(".")[:-1] ) + ".cna"
                cna_data += cna_file_name.encode() + (54 - len(cna_file_name) ) * b"\x00"
                cna_data += all_data
            if VERBOSE:
                prt_spooler("# parse data for %s took %.3f [s]"%(tagname,time.time() - data_proc_start) )

        # Battery Monitor
        wk = "Vbat = %.3f/%.3f [V]"%(vbat,rtc_mem.get("old_vdd3v3") ) if VERBOSE else "Vbat = %.3f [V]"%vbat
        if CNF_PARSER.is_cont_by_id(ca_id)[0]:  # Continuous mode
            if vbat <= CNF_PARSER.is_cont_by_id(ca_id)[1]:
                CNF_PARSER.clear_cont_by_id(ca_id)
                msg += "\n"+esc_blfg+time.strftime("%Y-%m-%d %H:%M:%S")+"     *** Quit continuous mode"+esc_norm+"  "
            if vbat < CNF_PARSER.aprt.get_param("lowbatt"):
                msg += esc_strng+wk+esc_norm
            else:
                msg += wk
        else:
            # Check for "impossible data"
            if vbat < 0:
                err_in = []
                code = int(-vbat // 10)
                if code & 64: err_in.append("POW_SW")
                if code & 32: err_in.append("FLASH_MEM")
                if code & 16: err_in.append("SPIFFS")
                if code &  8: err_in.append("ADXL345")
                if code &  4: err_in.append("SRAM")
                if ver_nums > 2000000:  # hw >= 2 and fw > 0.0.0
                    if code &  2: err_in.append("TIMER")
                    if code &  1: err_in.append("DEG_C")
                else:
                    code = code & 0xfffffffc
                if code == 0: err_in =["unknown"]
                err_in = ','.join(err_in)
                hw_err = "\n"+esc_strng+"*** HW error: "+err_in+esc_norm
                local_log(wk+" **HW error** **HW error** "+err_in)
                msg += esc_strng+wk+esc_norm+hw_err
            elif vbat < CNF_PARSER.aprt.get_param("lowbatt"):
                low_bat = (
                        "\n\x07    "+esc_strng+"*** Low Battery * Low Battery"
                        +" * Low Battery * Low Battery * Low Battery * "
                        +"Low Battery * Low Battery ***"+esc_norm)
                local_log(wk+" **LOW**")
                msg += esc_strng+wk+esc_norm+low_bat
            else:
                msg += wk

    if D_DIR_BUSY:
        # Pirnt interim message
        msg += ", dt: %f\n"%time_diff
        time_diff_sent = True
        PRT_LOCK.acquire()
        PRT_Q.put(msg)
        PRT_LOCK.release()
        msg = ""

    # Save
    if save_data:
        while D_DIR_BUSY:   # block until the data dir becomes ready
            time.sleep(0.1)

        # dir/path for all file_types
        prime_root = CNF_PARSER.aprt.get_root() if CNF_PARSER.aprt.get_sync() == "off_app_only" else DATA_DIR
        cair_dir = os.path.join(prime_root, tagname)
        cair_path = os.path.join(cair_dir,file_name)
        if not os.path.exists(cair_dir): os.makedirs(cair_dir)
        # dir/path for summary_csv+cna
        if CNF_PARSER.aprt.get_effective_file_type() == "summary_csv+cna":
            cair_dir2 = os.path.join(prime_root,"+plus_cna",tagname)
            cair_path2 = os.path.join(cair_dir2,'.'.join(file_name.split('.')[:-1]+["cna",] ) )
            if not os.path.exists(cair_dir2): os.makedirs(cair_dir2)

        if CNF_PARSER.aprt.get_sync() == "on":  # Also copy the data to APP_ROOT if DATA_SYNC == on
            # dir/path for all file_types
            app_dir = os.path.join(CNF_PARSER.aprt.get_root(), tagname)
            app_path = os.path.join(app_dir,file_name)
            if not os.path.exists(app_dir): os.makedirs(app_dir)
            # dir/path for summary_csv+cna
            if CNF_PARSER.aprt.get_effective_file_type() == "summary_csv+cna":
                app_dir2 = os.path.join(CNF_PARSER.aprt.get_root(), "+plus_cna", tagname)
                app_path2 = os.path.join(app_dir2,'.'.join(file_name.split('.')[:-1]+["cna",] ) )
                if not os.path.exists(app_dir2): os.makedirs(app_dir2)

        # Save data to the primary dir
        try:
            if CNF_PARSER.aprt.get_effective_file_type() in "csv summary_csv summary_csv+cna".split():
                with codecs.open(cair_path, "w", encoding='utf-8', errors='backslashreplace') as f:
                    f.write(conf_parser.UTF8BOM)
                    f.write(("Ident,"+id+"\n"))
                    f.write(("Tag,"+tagname+"\n"))
                    f.write(data)
            else:   # CNF_PARSER.aprt.get_effective_file_type() == "cna"
                with open(cair_path, "wb") as f:
                    f.write(data)
        except IOError as e:
            if e[0] == 13:
                wk = "%s(%s): Failed to save data to %s!"%(tagname,ca_id,cair_path)
                local_log(wk)
                msg += esc_strng+wk+esc_norm+"\r\n"
            else:
                raise

        # additional data for summary_csv+cna
        if CNF_PARSER.aprt.get_effective_file_type() == "summary_csv+cna":
            try:
                with open(cair_path2, "wb") as f:
                    f.write(cna_data)
            except IOError as e:
                if e[0] == 13:
                    wk = "%s(%s): Failed to save data to %s!"%(tagname,ca_id,cair_path2)
                    local_log(wk)
                    msg += esc_strng+wk+esc_norm+"\r\n"
                else:
                    raise

        # if CNF_PARSER.aprt.get_gen() > 0:   # Save to under CAIR_ROOT and then copy to APP_ROOT if DATA_GEN > 0
        if CNF_PARSER.aprt.get_sync() == "on":  # Also copy the data to APP_ROOT if DATA_SYNC == on
            try:
                shutil.copy2(cair_path, app_path)   # copy file (including metadta)
            except IOError as e:
                if e[0] == 13:
                    wk = "%s(%s): Failed to copy file to %s!"%(tagname,ca_id,app_path)
                    local_log(wk)
                    msg += esc_strng+wk+esc_norm+"\r\n"
                else:
                    raise

            # copy additional data for summary_csv+cna
            if CNF_PARSER.aprt.get_effective_file_type() == "summary_csv+cna":
                try:
                    shutil.copy2(cair_path2, app_path2) # copy file (including metadta)
                except IOError as e:
                    if e[0] == 13:
                        wk = "%s(%s): Failed to copy file to %s!"%(tagname,ca_id,app_path2)
                        local_log(wk)
                        msg += esc_strng+wk+esc_norm+"\r\n"
                    else:
                        raise

        # Update status on memory
        CNF_PARSER.update_stat_by_tag(tagname,vbat,sample_ts,sched_now,sched_next)
        if VERBOSE:
            try:
                with codecs.open(CNF_PARSER.rpt_measurements, "w", encoding='utf-8', errors='backslashreplace') as f:
                    CNF_PARSER.stat_report(f)
            except IOError as e:
                if e[0] == 13:
                    if VERBOSE: raise
                else:
                    raise

        _FILE_SAVED = True

    # Dump Timing
    if TIMING_DUMP:
        def mk_strts(x):
            s = int(x)
            ms = 1e3*(x%1)
            while ms > 999:
                ms -= 1000
                s += 1
            return time.strftime("%Y-%m-%d %H:%M:%S.", time.localtime(s) ) + "%03.0f"%(ms)
        tgt_dir = os.path.join("CAIR_ROOT", TDUMP_DIR)
        tgt_path = os.path.join(tgt_dir,ca_id+".txt")
        if not os.path.exists(tgt_dir): os.makedirs(tgt_dir)
        old_vbat = 0 if rtc_mem is None else rtc_mem.get("old_vdd3v3")
        # logrotate
        gen = cna_logrotate.rotate(tgt_path)
        if gen is not None:
            msg = "$$ "+time.strftime("%Y-%m-%d %H:%M:%S ")+"Log %s rotated, now %d additional generation(s)"%(os.path.split(tgt_path)[-1],gen)
            prt_spooler(esc_grbg+msg+esc_norm)
            put_log(msg)
        try:
            with codecs.open(tgt_path, "a", encoding='utf-8', errors='backslashreplace') as f:
                try:
                    rec = "%f,%f,%f,%f,%s,%.1f,%.1f,%.0f\n"%(
                                                    vbat,
                                                    old_vbat,
                                                    sess_time_sec,
                                                    clck_adj_dly,
                                                    mk_strts(sample_ts),
                                                    data_obje.dbldata[49],  # V2: AP_RSSI
                                                    data_obje.dbldata[50],  # V2: Dev_Tmp
                                                    data_obje.dbldata[51]   # V2: Versions
                                                    )
                except AttributeError:
                    rec = "%f,%f,%f,%f,%s\n"%(
                                                    vbat,
                                                    old_vbat,
                                                    sess_time_sec,
                                                    clck_adj_dly,
                                                    mk_strts(sample_ts)
                                                    )
                f.write(rec)
        except IOError as e:
            if e[0] == 13:
                if VERBOSE: raise
            else:
                raise

    if CNF_PARSER.is_cont_by_id(ca_id)[0]:  # Continuous mode
        if vbat <= CNF_PARSER.is_cont_by_id(ca_id)[1]:
            CNF_PARSER.clear_cont_by_id(ca_id)
            msg += "\n"+esc_blfg+time.strftime("%Y-%m-%d %H:%M:%S")+"     *** Quit continuous mode"+esc_norm+"  "

    th_end = ts_w_ms()

    if VERBOSE:
        msg += "\n\t\t\t%s - %s"%(th_start,th_end)

    if not time_diff_sent:
        msg += ", dt: %f\n"%time_diff
    if sec_init_msg:
        msg += "$$! "+sec_init_msg+(": Data not saved..." if not save_data else "")+"\n"
    elif not save_data:
        msg += "$$! Data not saved...\n"

    PRT_LOCK.acquire()
    PRT_Q.put(msg)
    PRT_LOCK.release()

    # Key values
    # def get_key_values():
        # ax,ay,az = (0.0,0.0,0.0,)
        # rssi = rtc_mem.get("AP_RSSI")
        # rssi = 0.0 if rssi is None else rssi
        # dtmp = rtc_mem.get("Dev_Tmp")
        # dtmp = 0.0 if dtmp is None else dtmp
        # try:
            # ax,ay,az = data_obje.dbldata[1:4]
            # rssi,dtmp = data_obje.dbldata[49:51]
        # except AttributeError:
            # pass
        # return ax,ay,az,rssi,dtmp
    # msg += ">> %s=%s %s "%(tagname,ca_id,str_scd_now)+"{Ax,Ay,Az}={%.3f,%.3f,%.3f} RSSI=%.1f DevTmp=%.1f\n"%get_key_values()

    str_rssi_temp = "RSSI=n/a DevTmp=n/a"
    str_axyz = "{n/a,n/a,n/a} "
    try:
        # get values from rtc_mem
        _rssi = rtc_mem.get("AP_RSSI")
        _dtmp = rtc_mem.get("Dev_Tmp")
        if _rssi is not None and _dtmp is not None:
            str_rssi_temp = "RSSI=%.1f DevTmp=%.1f"%(_rssi,_dtmp)

        # get values from dbldata
        _ax,_ay,_az = data_obje.dbldata[1:4]
        str_axyz = "{%.3f,%.3f,%.3f} "%(_ax,_ay,_az)
        _rssi,_dtmp = data_obje.dbldata[49:51]
        str_rssi_temp = "RSSI=%.1f DevTmp=%.1f"%(_rssi,_dtmp)
    except AttributeError:
        pass
    msg = ">> %s=%s %s "%(tagname,ca_id,str_scd_now)+"{Ax,Ay,Az}=" + str_axyz + str_rssi_temp + "\n"

    PRT_LOCK.acquire()
    PRT_Q.put(msg)
    PRT_LOCK.release()

    # Delete the record
    try:
        del UDP_TCP_STAT[ca_id]
    except KeyError:
        pass    # Just ignore

    _LAST_TCP_END = time.time()


def kb_sense():
    rc = kb_sub()
    if rc not in "\x00 \xe0".split():
        return rc
    else:
        rc2 = kb_sub()
        while rc2 is None:
            rc2 = kb_sub()
        return rc+rc2
    

def kb_sub():
    if platform.platform().lower().startswith("windows"):
        if msvcrt.kbhit(): return msvcrt.getch().decode()
        else: return None
    else:
        if not linux_getch.kbhit(): return None
        return linux_getch.getch()
 
RUN_TCP = True
RUN_UDP = True
RUN_DEQ = True
RUN_LOGQ = True
RELOAD_PARAM = False

def listener():
    global approot_timer, EXIT_CODE, CNF_PARSER, BTS_CHKPNT_TT
    global RUN_TCP, RUN_UDP, RUN_DEQ, RUN_LOGQ, DEQ_PAUSE, RELOAD_PARAM
    global _FILE_SAVED, VERBOSE,STOP_DATA_MAN, _LAST_TCP_END
    _startup = True

    try:
        with codecs.open(CNF_PARSER.rpt_measurements, "w", encoding='utf-8', errors='backslashreplace') as f:
            CNF_PARSER.stat_report(f)
    except IOError as e:
        if e[0] == 13:
            if VERBOSE: raise
        else:
            raise

    cnf_load_tt = time.time()
    stat_rpt_min = 0
    
    # Launch PRT_Q Consumer thread
    t_prtq = threading.Thread(target=de_q)
    t_prtq.start()
    
    # Launch LOG_Q Consumer thread
    t_logq = threading.Thread(target=log_deq)
    t_logq.start()

    # Launch UDP responder thread
    t_udp = threading.Thread(target=udp_responder)
    t_udp.start()
    
    threads = []
    data_savers = []
    th_time = []
    th_ts_prev = None
    thread_started = False
    tcp_thre_num = 0
    _FILE_SAVED = False
    host = ''
    quit_wait = None
    confirm_wait = None
    prev_i_time = 0
    sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)     # Receive
    ## Menu Constants/Variables
    MENU_TOP_DICT = {"q":"quit start", "c":"config", "b":"status", "s":"status", "p":"params",}# "t":"timeout test",}
    MENU_TIMEOUT = 20   # second
    menu_state = None
    menu_begin = 0
    menu_time = 0
    menu_prompt = ""
    last_keypress = None
    skip_btm_updt = False
    d_manage_thread = None
    prev_minute = None


    try:
        with closing(sock):
            sock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
            sock.bind((host, LISTEN_PORT) )
            sock.listen(5)

            read_list = [sock,]
            client_dict = {}

            while RUN_TCP:
                ### Menu System
                if menu_state is not None and menu_begin > 0:
                    menu_time = time.time() - menu_begin
                else:
                    menu_time = 0

                last_keypress = kb_sense()
                if last_keypress is not None: last_keypress = last_keypress.lower()
                if menu_state is None:
                    menu_state = MENU_TOP_DICT.get(last_keypress)
                    if menu_state is not None:
                        menu_begin = time.time()
                    elif last_keypress is not None:
                        if menu_state is None:  # Don't do the below while menu is active
                            btm_line()
                            char_to_show = repr(last_keypress) if last_keypress < '!' or last_keypress > '~' else last_keypress
                            # Terminate with "\x03" will cause no newline at end
                            # prt_spooler(str_btm_line()+" 無効なキーが押された: %s"%char_to_show+"\x03")
                            prt_spooler(
                                    str_btm_line()
                                    +T.m0200%char_to_show
                                    +T.m0210
                                    +("|Ctrl+C|Ctrl+Break" if platform.platform().lower().startswith("windows") else "")
                                    +"]"
                                        )
                            prt_spooler(str_btm_line()+"\x03")
                            skip_btm_updt = True
                elif menu_time > MENU_TIMEOUT:
                    wk = "Menu state \"%s\" timed-out"%menu_state
                    put_log(wk)
                    prt_spooler(esc_strng+"?? "+wk+esc_norm)
                    menu_begin = 0
                    menu_time = 0
                    menu_state = None
                    DEQ_PAUSE = False

                # Show Parameters
                if menu_state == "params":
                    menu_state = "params shown"
                    rpt =  str_btm_clear() + "\n"
                    rpt += CNF_PARSER.param_report()
                    rpt += "\n\t" + esc_blfg + T.m0240 + esc_norm
                    rpt += "\x00"   # Terminate with NULL will cause DEQ_PAUSE = True and no newline at end
                    prt_spooler(rpt)
                if menu_state == "params shown" and menu_time > 10:
                    menu_begin = 0
                    menu_time = 0
                    menu_state = None
                    DEQ_PAUSE = False       # This will cause the bottom line to appear

                # Show Config
                if menu_state == "config":
                    menu_state = "config shown"
                    rpt =  str_btm_clear() + "\n"
                    rpt += CNF_PARSER.config_report()
                    rpt += "\n\t" + esc_blfg + T.m0240 + esc_norm
                    rpt += "\x00"   # Terminate with NULL will cause DEQ_PAUSE = True and no newline at end
                    prt_spooler(rpt)
                if menu_state == "config shown" and menu_time > 10:
                    menu_begin = 0
                    menu_time = 0
                    menu_state = None
                    DEQ_PAUSE = False       # This will cause the bottom line to appear

                # Show Status
                if menu_state == "status":
                    menu_state = "status shown"
                    bad_status_only = last_keypress == "b"
                    rpt =  str_btm_clear() + "\n"
                    rpt += CNF_PARSER.stat_report(bad_only=bad_status_only)
                    rpt += "\n\t" + esc_blfg + T.m0240 + esc_norm
                    rpt += "\x00"   # Terminate with NULL will cause DEQ_PAUSE = True and no newline at end
                    prt_spooler(rpt)
                if menu_state == "status shown" and menu_time > 10:
                    menu_begin = 0
                    menu_time = 0
                    menu_state = None
                    DEQ_PAUSE = False       # This will cause the bottom line to appear

                # Quit Logic
                if menu_state == "quit start":
                    menu_state = "quit wait"
                    btm_clear()
                    menu_prompt = T.m0250
                    # Terminate with "\x03" will cause no newline at end
                    prt_spooler(["\n\x03",menu_prompt+"\x03"] )
                    cdwn1 = 10
                    cdwn2 = 1
                    last_keypress = None

                if menu_state == "quit wait":
                    if   menu_time > 10:
                        menu_prompt += T.m0260
                        prt_spooler(menu_prompt)
                        menu_state = None
                    elif last_keypress == "n":
                        menu_prompt += T.m0270
                        prt_spooler(menu_prompt)
                        menu_state = None
                    elif last_keypress == "y":
                        menu_prompt += " Y\n\x03"  # Terminate with "\x03" will cause no newline at end
                        menu_prompt2 = T.m0280
                        # Terminate with "\x03" will cause no newline at end
                        prt_spooler([menu_prompt,menu_prompt2+"\x03"] ) 
                        menu_prompt = menu_prompt2
                        menu_state = "quit confirm"
                        menu_begin = time.time()
                        menu_time = 0
                        cdwn1 = 10
                        cdwn2 = 1
                        last_keypress = None
                    else:   # count-down
                        if menu_time > cdwn2:
                            cdwn1 -= 1
                            cdwn2 += 1
                            menu_prompt += "%d "%cdwn1
                            prt_spooler(menu_prompt+"\x03") # Terminate with "\x03" will cause no newline at end

                if menu_state == "quit confirm":
                    if   menu_time > 10:
                        menu_prompt += T.m0290
                        prt_spooler(menu_prompt)
                        menu_state = None
                    elif last_keypress == "n":
                        menu_prompt += T.m0300
                        prt_spooler(menu_prompt)
                        menu_state = None
                        EXIT_CODE = 0
                        RUN_TCP = False
                        STOP_DATA_MAN = True
                    elif last_keypress == "y":
                        menu_prompt += T.m0310
                        prt_spooler(menu_prompt)
                        menu_state = None
                    else:   # count-down
                        if menu_time > cdwn2:
                            cdwn1 -= 1
                            cdwn2 += 1
                            menu_prompt += "%d "%cdwn1
                            prt_spooler(menu_prompt+"\x03") # Terminate with "\x03" will cause no newline at end

                # Check for Reboot File
                if chk_reboot():
                    EXIT_CODE = 99
                    RUN_TCP = False
                    STOP_DATA_MAN = True

                # Bottom Line Update
                int_time = int((time.time() - BTS_START_TT)/5)  # Every 5 seconds
                if not skip_btm_updt and prev_i_time != int_time:
                    prev_i_time = int_time
                    if menu_state is None:  # Don't do the below while menu is active
                        prt_spooler("") # Force display new bottom line
                skip_btm_updt = False

                # 4th arg is timeout [s], 0 for nonblocking
                readable, writable, errored = select.select(read_list, [], [], 0.1)
                for s in readable:
                    if s is sock:
                        client, addr = sock.accept()
                        read_list.append(client)
                        client_dict[client] = addr
                    else:
                        s.settimeout(8.0)
                        addr = client_dict.get(s)
                        # manage list and dict of sockets
                        read_list.remove(s)
                        if addr is not None:
                            client_dict.pop(s)
                        # Launch socket processing thread
                        my_name = "TCP-%06d"%tcp_thre_num
                        ### Allow multi-threading for number of cores
                        prev_name = "TCP-%06d"%(0xffff&(tcp_thre_num - min(4,multiprocessing.cpu_count() ) ) )
                        ### Next thread number
                        tcp_thre_num = 0xffff & (tcp_thre_num + 1)  # limit to 0-65535
                        if VERBOSE:
                            if PARSE_SERIALIZE:
                                prt_spooler(
                                    "#$ Launch TCP thread %s which will wait for completion of %s to start data parsing."
                                    %(my_name,prev_name) )
                            else:
                                prt_spooler("#$ Launch TCP thread %s."%my_name)
                        t = threading.Thread(target=read_socket, name=my_name,args=(s, addr, data_savers, prev_name) )
                        if th_ts_prev is None:
                            th_ts_prev = time.time()
                        else:
                            now = time.time()
                            th_time.append(now - th_ts_prev)
                            th_ts_prev = now
                        threads.append(t)
                        t.start()
                        # set preliminary value -- +600 sec (10 min) is some safe assumption
                        _LAST_TCP_END = time.time() + 600
                        thread_started = True

                # Remove inactive thred
                active_threads = [i for i in threading.enumerate() if i.name.startswith("TCP-") ]
                thread_cnt = len(active_threads)
                if threads:
                    for s in threads:
                        if s not in active_threads:
                            th_name = s.name
                            s.join()    # JIC
                            threads.remove(s)
                            if VERBOSE:
                                msg = (
                                    "# TCP thread %s removed from list (active thread%s: %d)"
                                    % (th_name,"s" if thread_cnt != 1 else "",thread_cnt)
                                    )
                                prt_spooler(msg)
                else:
                    data_savers = []

                # After inactivity
                tcp_thre_cnt = len([i for i in active_threads if i.name.startswith("TCP-") ] )
                # print("##### Number of TCP threads: %2d"%tcp_thre_cnt)
                if tcp_thre_cnt == 0 and (time.time() - _LAST_TCP_END) > 15.0:
                    if thread_started:
                        thread_started = False
                        # JIC: Wait all threads to complete
                        n_threads = 0
                        join_start = time.time()
                        for i in threads:
                            i.join()
                            n_threads += 1
                        if n_threads:
                            prt_spooler(
                                "# %d TCP thread"%n_threads+("s" if n_threads > 1 else "")
                                +" joined (halted %.3f s)"%(time.time() - join_start)
                            )
                        threads = []

                        # Congested Packets Interval
                        if VERBOSE:
                            if th_time:
                                wk = "(%.3f"%th_time[0]
                                for i in th_time[1:]: wk += ", %.3f"%i
                                wk += ")"
                                prt_spooler("# Congested Packets Interval: %s [s]"%wk)
                            else:
                                prt_spooler("# Congested Packets Interval: None")
                        prt_spooler("")

                        threads = []
                        th_time = []
                        th_ts_prev = None

                        # clean-up client_dict
                        for k in client_dict.keys():
                            if k not in read_list: client_dict.pop(k)

                    # Manage data files
                    sched30 = CNF_PARSER.aprt.get_param("sched30")
                    min_tenth = int(datetime.datetime.now().minute / 10)
                    # cond_1 = (time.time() - approot_timer) > (60*CNF_PARSER.aprt.get_sync() )
                    cond_0 = (time.time() - approot_timer) > (60*MIN_SYNC_INTVL_MIN)
                    cond_1 = CNF_PARSER.aprt.get_sync() == "on"
                    cond_2 = CNF_PARSER.aprt.get_gen() > 0
                    cond_3 = (not sched30) or (min_tenth in [1,4] )
                    # cond = _FILE_SAVED and cond_1 and cond_2 and cond_3
                    cond = _FILE_SAVED and cond_0 and (cond_1 or cond_2) and cond_3
                    ##
                    ## The following message may cause dead-lock conditions
                    ##
                    # if cond and D_DIR_BUSY:
                        # put_log("** Prevent duplicate data_manage thread")
                        # if VERBOSE:
                            # prt_spooler("** Prevent duplicate data_manage thread")
                    # elif cond:
                    if cond and not D_DIR_BUSY:
                        _FILE_SAVED = False
                        if d_manage_thread: d_manage_thread.join()  # JIC
                        cna_dir = CNF_PARSER.aprt.get_root() if CNF_PARSER.aprt.get_sync() == "off_app_only" else DATA_DIR
                        approot_timer = time.time()
                        d_manage_thread = threading.Thread(
                                        target=data_manage,
                                        args=(
                                            cna_dir,
                                            CNF_PARSER.aprt.get_root(),
                                            CNF_PARSER.aprt.get_gen(),
                                            CNF_PARSER.aprt.get_effective_file_type(),
                                            cond_1
                                            )
                                        )
                        d_manage_thread.start()
                        # Save current stat as well
                        CNF_PARSER.save_stat()

                    # Status Report
                    now_min = time.localtime().tm_min
                    if now_min != stat_rpt_min and now_min%10 == 4: # at 04, 14,...54 min of the hour
                        stat_rpt_min = now_min
                        try:
                            with codecs.open(CNF_PARSER.rpt_measurements, "w", encoding='utf-8', errors='backslashreplace') as f:
                                CNF_PARSER.stat_report(f)
                        except IOError as e:
                            if e[0] == 13:
                                if VERBOSE: raise
                            else:
                                raise

                    # Config Reload
                    if (RELOAD_PARAM or chk_reload() or 
                        (CNF_PARSER.aprt.get_param("sched30")
                        and (time.time() - cnf_load_tt) > 90
                        and time.strftime("%M") in CNF_PARSER.aprt.get_param("conf_reload") ) ):
                        RELOAD_PARAM = False
                        cnf_load_tt = time.time()

                        # Save current stat first
                        CNF_PARSER.save_stat()

                        try:
                            # try loading
                            cnf_wk = conf_parser.key_tag_sched()
                        except Exception as e:
                            # don't replace params/config if load failed
                            # wk = "Config reload fail %s"%repr(e)
                            wk = T.m0320%repr(e)
                            put_log(wk)
                            prt_spooler(esc_strng+"!! "+time.strftime("%Y-%m-%d %H:%M:%S ")+wk+esc_norm)
                            continue    # no further processing
                        CNF_PARSER = cnf_wk
                        VERBOSE = CNF_PARSER.aprt.is_verbose()
                        wk = T.m0330
                        prt_spooler(esc_grbg+"** "+time.strftime("%Y-%m-%d %H:%M:%S ")+wk+esc_norm)
                        put_log(wk)

                    # Check overdue measurments
                    current_minute = datetime.datetime.now().minute
                    # Every multiple of 5 minute
                    if _startup or ((current_minute%5) == 0 and prev_minute != current_minute):
                        _startup = False
                        prev_minute = current_minute
                        overdue = CNF_PARSER.get_overdue()
                        for t,i,d in overdue:
                            wk = t + "(" + i + "): " + T.m0340 + h_m_s(d) + T.m0341
                            put_log(wk)
                            prt_spooler(esc_strng+"!!\x07 "+time.strftime("%Y-%m-%d %H:%M:%S ")+wk+esc_norm+"\n")


    # Make sure no processing in the loop below

    except KeyboardInterrupt:
        EXIT_CODE = 99
    except Exception as e:
        put_log("Uncaught exception %r"%e)
        put_log(traceback.format_exc() )
        time.sleep(5)   # Make sure the message is logged
        raise

    finally:
        STOP_DATA_MAN = True

        RUN_UDP = False
        t_udp.join()
        print("\n\n# UDP thread joined")

        RUN_DEQ = False
        t_prtq.join()
        print("# PRT_Q thread joined")

        RUN_LOGQ = False
        t_logq.join()
        print("# LOG_Q thread joined")

        # Send stop request to data_save objects
        for s in data_savers:
            s.stop()

        # Wait all TCP threads to complete
        n_threads = 0
        for i in threads:
            i.join()
            n_threads += 1
        if n_threads:
            print("# %d TCP thread"%n_threads+("s" if n_threads > 1 else "")+" joined")

        # Packet Interval
        if th_time:
            wk = "(%.3f"%th_time[0]
            for i in th_time[1:]: wk += ", %.3f"%i
            wk += ")"
            print("# Packet Interval: %s [s]"%wk)
        else:
            if VERBOSE: print("# Packet Interval: None")
        print()

        # if VERBOSE: CNF_PARSER.stat_report()

# Print Spooler
def prt_spooler(msg):
    v = []
    if   type(msg) == str:
        v = [msg,]
    elif type(msg) in [list,tuple]:
        v = msg
    PRT_LOCK.acquire()
    for i in v:
        PRT_Q.put(i)
    PRT_LOCK.release()

# Print Spooler
def my_raise(e):
    global RUN_TCP,STOP_DATA_MAN

    t = threading.current_thread().name
    wk1 = T.m0350
    wk2 = " %r in thread %s\n"%(e,t) + traceback.format_exc()
    prt_spooler(esc_strng + time.strftime("# %Y-%m-%d %H:%M:%S ") + wk1 + esc_norm + wk2)
    put_log(wk1 + wk2)
    time.sleep(2)   # Give time to despooler to show message
    RUN_TCP = False
    STOP_DATA_MAN = True
    time.sleep(2)   # Give time to other threads to complete

def udp_responder():
    try:
        udp_responder_sub()
    except Exception as e:
        my_raise(e)
def udp_responder_sub():
    global RUN_TCP,STOP_DATA_MAN

    host = ""
    data = ""
    prev_data = ""
    id = ""
    addr = None
    bufsize = 4096
    dev_dict = {}

    rx_sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    tx_sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)

    with closing(rx_sock), closing(tx_sock):
        try:
            rx_sock.bind((host, BCAST_PORT) )
            rx_sock.setblocking(False)
        except socket.error as e:
            if e[0] == 10048:

                RUN_TCP = False
                STOP_DATA_MAN = True
                prt_spooler("\n"+esc_strng+T.m0360+esc_norm+"\n")
                time.sleep(1)   # Give time to other threads to complete
            else:
                my_raise(e)
            return

        # Mainloop
        prt_spooler(time.strftime("%Y-%m-%d %H:%M:%S UDP Responder starting\n") )
        while RUN_UDP:
            try:
                # RX
                prev_data = data
                prev_addr = addr
                data,addr = rx_sock.recvfrom(bufsize)

                if not data:
                    # wk = "UDP: empty packet"
                    wk = T.m0370
                    put_log(wk)
                    prt_spooler(esc_strng+"!!\x07 "+wk+esc_norm)
                    continue

                if len(data) != 28: # sizeof(udp_tx_t)
                    # wk = "UDP: invalid data length %d"%len(data)
                    wk = T.m0380%len(data)
                    put_log(wk)
                    prt_spooler(esc_strng+"!!\x07 "+wk+esc_norm)
                    continue

                if prev_data == data:
                    # wk = "UDP: same data repeated"
                    wk = T.m0390
                    put_log(wk)
                    prt_spooler(esc_strng+"!!\x07 "+wk+esc_norm)
                    continue

                prev_id = id
                id = data[:16].split(b'\x00')[0].decode()
                if prev_id == id and prev_addr != addr:
                    # wk = "UDP: same ID %s from different address %r & %r"%(id,prev_addr,addr)
                    wk = T.m0400%(id,prev_addr,addr)
                    put_log(wk)
                    prt_spooler(esc_strng
                        +"!!\x07 "+wk+"\n"
                        +esc_norm
                        +"\n"+repr(data) )
                    continue

                # Check Tag setting
                tagname = CNF_PARSER.get_tag(id)
                if tagname is None:
                    # wk = "UDP: conanair %s does not have valid tags.conf entry"%id
                    wk = T.m0410%id
                    put_log(wk)
                    prt_spooler(esc_strng+"!!\x07 "+wk+esc_norm)
                    continue

                # Get connection key
                key = CNF_PARSER.get_key(id)
                if key is None:
                    # wk = "UDP: conanair %s does not have valid key"%id
                    wk = T.m0420%id
                    put_log(wk)
                    prt_spooler(esc_strng+"!!\x07 "+wk+esc_norm)
                    continue

                # Age dev_dict
                age_sec = 30 if CNF_PARSER.is_cont_by_id(id)[0] else 60
                now = time.time()
                k_to_del = []
                for k in dev_dict.keys():
                    if (now - dev_dict[k]["ts"] ) > age_sec:
                        k_to_del.append(k)
                for k in k_to_del:
                    del dev_dict[k]
                        # prt_spooler(k+" aged")
                # Check conanair with dev_dict
                if id in dev_dict.keys():
                    dev_dict[id]["count"] += 1
                    if dev_dict[id]["count"] >= 3:
                        # wk = "UDP: %s(%s) Warning: Probable unmatched auth-key file"%(tagname,id)
                        wk = T.m0430%(tagname,id)
                        prt_spooler(esc_strng+"!!\x07 "+wk+esc_norm)
                        if not dev_dict[id]["logged"]:
                            put_log(wk)
                            dev_dict[id]["logged"] = True
                else:
                    dev_dict[id] = {"ts": now, "logged": False, "count": 1, }
                
                seq,elp_us,nonce = struct.unpack("III",data[16:28] )
                elp_s = 1e-6*elp_us
                tt = time.time()
                ms = tt % 1.0
                ts = time.strftime("%Y-%m-%d %H:%M:%S",time.localtime(tt) ) + ".%03d"%int(ms*1000)
                adj_tt = tt - elp_s # Start of sampling
                adj_ms = adj_tt % 1.0
                adj_ts = time.strftime("%H:%M:%S",time.localtime(adj_tt) ) + ".%03d"%int(adj_ms*1000)
                tagname = CNF_PARSER.get_tag(id)
                tagname = "None" if tagname is None else tagname
                prt_spooler("++ UDP: %s(ID=%s) %s, %s,%10d, %.3f, %s"%(tagname,id,ts,repr(addr),seq,elp_s,adj_ts) )
                
                # Record in the dict
                UDP_TCP_STAT[id] = time.time()
                
                # TX
                id_seq = data[:20]  # id + seq
                ts = struct.pack("d", adj_tt)
                cnonce = os.urandom(4)

                k_idx = 0x1f & seq
                hash = hashlib.md5(data[:16]+data[24:28]+cnonce+key[k_idx:k_idx+32] ).digest()  # id + received nonce + cnonce + key

                nonce = os.urandom(4)
                tx_sock.sendto(id_seq + ts + cnonce + hash + nonce, (addr[0],TX_PORT) )
            except socket.error as e:
                # data = ''
                # addr = None
                err = e.args[0]
                if err == 10035 or err == 11:
                    time.sleep(0.01)    # 10ms
                elif err == 10054:  # disconnected by remote peer
                    prt_spooler(esc_strng+"!!\x07 UDP: Disconnected by remote peer\n"+esc_norm)
                else:
                    my_raise(e)
                    return
            except Exception as e:
                my_raise(e)
                return

def str_uptime():
    up_seconds = round(time.time() - BTS_START_TT)
    up_day = int(up_seconds / 24 / 3600)
    up_hrs = int(up_seconds / 3600) % 24
    up_min = int(up_seconds / 60) % 60
    up_sec = int(up_seconds) % 60
    return "%dd %dh %dm %ds"%(up_day,up_hrs,up_min,up_sec)

def str_btm_clear():
    return "\r"+79*" "+"\r"
            
def str_btm_line(msg=""):
    out = str_btm_clear()
    if msg:
        out += msg
        out += "\n"
    out += esc_neg2+" Run "+str_uptime()+" "+T.m0440+esc_norm
    return out

def btm_clear():
    print(str_btm_clear(),end="")
            
def btm_line(msg=""):
    print(str_btm_line(msg),end="")
    sys.stdout.flush()

last_banner_tt = time.time()
def de_q():
    global last_banner_tt
    prt_spooler(time.strftime("%Y-%m-%d %H:%M:%S PRT_Q Consumer starting") )
    cnt = 0
    while RUN_DEQ:
        cnt += deq_sub()
        if cnt > 30 or (time.time() - last_banner_tt) > 3600:   # every 30 lines or 1 hr
            last_banner_tt = time.time()
            cnt = 0
            # Runtime Checkpoints
            msg = esc_nega+time.strftime("*** %Y-%m-%d %H:%M:%S ")
            msg += "conanair Base Station App. %s [(c) NSXe] is up and running "%BTS_VERSION
            msg += "for %s"%str_uptime()+esc_norm+"\n"
            prt_spooler(msg)

prev_deq_pause = False
def deq_sub():
    global DEQ_PAUSE,prev_deq_pause
    if DEQ_PAUSE:
        time.sleep(0.05)    # 50ms
        prev_deq_pause = True
        return 0
    if prev_deq_pause:
        btm_line()
        prev_deq_pause = False
    PRT_LOCK.acquire()
    q_empty = PRT_Q.empty()
    PRT_LOCK.release()
    if q_empty:
        time.sleep(0.05)    # 50ms
        return 0
    else:
        PRT_LOCK.acquire()
        data = PRT_Q.get()
        PRT_LOCK.release()
        # remove BOM in UTF16 form
        pos = data.find("\ufeff")
        while pos >= 0:
            data = data[:pos] + data[pos+1:]
            pos = data.find("\ufeff")
        test1 = data.endswith("\x00")
        test2 = data.endswith("\x03")
        if test1 or test2:
            data = data[:-1]
            print(str_btm_clear() + data,end="")
            sys.stdout.flush()
            if test1:
                DEQ_PAUSE = True
            return 0
        btm_line(data)
        if data:
            con_log_wrt(data+"\n")
            return len((data+"\n").splitlines() )
        return 0

def con_log_wrt(msg):
    conlog = CNF_PARSER.aprt.get_conlog()
    if conlog:
        # logrotate
        gen = cna_logrotate.rotate(conlog,limit_kb=5*1024)  # limit = 5MB
        if gen is not None:
            msg = "$$ "+time.strftime("%Y-%m-%d %H:%M:%S ")+"Log %s rotated, now %d additional generation(s)"%(os.path.split(conlog)[-1],gen)
            prt_spooler(esc_grbg+msg+esc_norm)
            put_log(msg)
        try:
            with codecs.open(conlog, "a", encoding='utf-8', errors='backslashreplace') as f:
                f.write(msg)
        except IOError as e:
            if e[0] == 13:
                if VERBOSE: raise
            else:
                raise

def put_log(msg):
    LOG_LOCK.acquire()
    LOG_Q.put(msg)
    LOG_LOCK.release()

def log_deq():
    prt_spooler(time.strftime("%Y-%m-%d %H:%M:%S LOG_Q Consumer starting") )
    while RUN_LOGQ:
        LOG_LOCK.acquire()
        q_empty = LOG_Q.empty()
        LOG_LOCK.release()
        if q_empty:
            time.sleep(0.05)    # 50ms
        else:
            LOG_LOCK.acquire()
            data = LOG_Q.get()
            LOG_LOCK.release()
            evt_logger(data)

def evt_logger(msg):
    logline = []
    try:
        if os.path.exists(CNF_PARSER.rpt_evtlog):
            with codecs.open(CNF_PARSER.rpt_evtlog,"r", encoding='utf-8', errors='backslashreplace') as f:
                logline = [i.strip() for i in f.read().splitlines() ]
        if logline:
            # Check against max. lines
            if len(logline) > LOG_MAX:
                logline = logline[-LOG_MIN:]
            # Check if the 1st line is not OK
            if logline[0] != (conf_parser.UTF8BOM+conf_parser.REPORT_TITLE[:-2] ):
                # Remove BOM if exists
                if logline[0].startswith(conf_parser.UTF8BOM):
                    logline[0] = logline[0][len(conf_parser.UTF8BOM):]
                # Check if title exists
                if not logline[0].startswith(conf_parser.REPORT_TITLE[:-2] ):
                    logline = [conf_parser.REPORT_TITLE[:-2],"",] + logline
                # Add BOM
                logline[0] += conf_parser.UTF8BOM
            # Write new lines back
            with codecs.open(CNF_PARSER.rpt_evtlog,"w", encoding='utf-8', errors='backslashreplace') as f:
                f.write("\n".join(logline[-LOG_MIN:] )+"\n")
        else:
            with codecs.open(CNF_PARSER.rpt_evtlog,"w", encoding='utf-8', errors='backslashreplace') as f:
                f.write(conf_parser.UTF8BOM + conf_parser.REPORT_TITLE)
        with codecs.open(CNF_PARSER.rpt_evtlog,"a", encoding='utf-8', errors='backslashreplace') as f:
            print(time.strftime("%Y-%m-%d %H:%M:%S ")+msg,file=f)
    except IOError as e:
        if e[0] == 13:
            if VERBOSE: raise
        else:
            raise

def chk_ctrlfile(testfile):
    if os.path.exists(testfile):
        count = 0
        while count < 10 and os.path.exists(testfile):
            try:
                os.remove(testfile)
            except IOError:
                count += 1
                time.sleep(0.1)
        return count < 10
    else:
        return False

def chk_reboot():
    return chk_ctrlfile(REBOOT_FILE)

def chk_reload():
    return chk_ctrlfile(RELOAD_FILE)

def ctrl_brk_handler(ctrl):
    global EXIT_CODE,RUN_TCP,RELOAD_PARAM,STOP_DATA_MAN

    ctrl_dict = {
            win32con.CTRL_C_EVENT:("Ctrl+C",-1),
            win32con.CTRL_BREAK_EVENT:("Ctrl+Break",99),
            win32con.CTRL_CLOSE_EVENT:("Close Console",96),
            win32con.CTRL_LOGOFF_EVENT:("User Logoff",97),
            win32con.CTRL_SHUTDOWN_EVENT:("System Shutdown",98),
    }
    if ctrl in ctrl_dict.keys():
        if ctrl_dict[ctrl][1] < 0:
            RELOAD_PARAM = True
            msg = "Caught '%s' -- App. will reload parameters."%ctrl_dict[ctrl][0]
            evt_logger(msg)
            prt_spooler(esc_blfg+msg+esc_norm)
        else:
            EXIT_CODE = ctrl_dict[ctrl][1]
            msg = "Caught '%s' -- App. will exit with code %d"%(ctrl_dict[ctrl][0],EXIT_CODE)
            evt_logger(msg)
            print("\n"+msg)
            RUN_TCP = False
            STOP_DATA_MAN = True
            time.sleep(1)
        return 1
    return 0

if __name__ == "__main__":
    if not platform.platform().lower().startswith("windows"):
        atexit.register(linux_getch.set_normal_term)
        linux_getch.set_curses_term()

    beep()
    # Install Ctrl+Break handler
    if platform.platform().lower().startswith("windows"):
        win32api.SetConsoleCtrlHandler(ctrl_brk_handler, True)
    else:
        pass

    # Remove REBOOT_FILE and RELOAD_FILE on startup
    chk_reboot()
    chk_reload()

    BTS_START_TT = time.time()
    msg = esc_nega+"Starting conanair Base Station %s [(c) NSXe]"%BTS_VERSION+esc_norm
    prt_spooler(time.strftime("%Y-%m-%d %H:%M:%S ")+msg)
    evt_logger(msg)
    EXIT_CODE = -1

    listener();

    msg = "App. exit with code: %d"%EXIT_CODE
    if EXIT_CODE == -1:
        EXIT_CODE = 0
        msg += "\n(The code -1 is replaced with 0 (zero) to prevent exiting quietly.)"
    evt_logger(msg)
    print(msg)

    time.sleep(1)
    if PAUSE_CMD:
        os.system(PAUSE_CMD)
    sys.exit(EXIT_CODE)
