#include <stdio.h>
#include <math.h>
#include <stdlib.h>
// stdint
#ifdef _MSC_VER
typedef __int32 int32_t;
typedef unsigned __int32 uint32_t;
typedef __int64 int64_t;
typedef unsigned __int64 uint64_t;
#else
#include <stdint.h>
#endif

#define DUMP_IN  "eema_core_in.txt"
#define DUMP_OUT "eema_core_out.txt"
// #define DEBUG


#ifdef _MSC_VER
__declspec(dllexport) double * EEMA(
#else
double * EEMA(
#endif	// ifdef _MSC_VER
								const uint32_t N,	// Number of elements
								double * x,			// I/O uffer
								const double a,		// coefficient
								const double b,		// coefficient
								const double ini	// initial value
								) {

	double r;	// accumulator
	int i;

#ifdef DEBUG
	FILE * fp;

	fp = fopen (DUMP_IN, "w");
	fprintf (fp, "** DEBUG: EEMA_core_XX.dll EEMA function **\n");
	fprintf (fp, "a = %11.6f, b = %11.6f, ini = %11.6f\n",a,b,ini);
	fprintf (fp, "Input:\n");
	for (i=0; i<N; i++) {
		fprintf (fp, "%11.6f\n",x[i]);
	}
	fclose(fp);
#endif //def DEBUG

// Process
	r = ini;
	for (i=0; i<N; i++) {
		r = a*x[i] + b*r;
		x[i] = r;
	}

#ifdef DEBUG
	fp = fopen (DUMP_OUT, "w");
	fprintf (fp, "** DEBUG: EEMA_core_XX.dll EEMA function **\n");
	fprintf (fp, "a = %11.6f, b = %11.6f, ini = %11.6f\n",a,b,ini);
	fprintf (fp, "Output:\n");
	for (i=0; i<N; i++) {
		fprintf (fp, "%11.6f\n",x[i]);
	}
	fclose(fp);
#endif //def DEBUG
	
	return (x);
}

#ifdef _MSC_VER
__declspec(dllexport) double * HPF(
#else
double * HPF(
#endif	// ifdef _MSC_VER
								const uint32_t N,	// Number of elements
								double * x,			// I/O uffer
								const double a,		// coefficient
								const double b,		// coefficient
								const double ini	// initial value
								) {

	double r,s;	// accumulator
	int i;

#ifdef DEBUG
	FILE * fp;

	fp = fopen (DUMP_IN, "w");
	fprintf (fp, "** DEBUG: EEMA_core_XX.dll HPF function **\n");
	fprintf (fp, "a = %11.6f, b = %11.6f, ini = %11.6f\n",a,b,ini);
	fprintf (fp, "Input:\n");
	for (i=0; i<N; i++) {
		fprintf (fp, "%11.6f\n",x[i]);
	}
	fclose(fp);
#endif //def DEBUG

// Process
	r = ini;
	for (i=0; i<N; i++) {
		s = x[i] - r;
		r = a*x[i] + b*r;
		x[i] = s;
	}

#ifdef DEBUG
	fp = fopen (DUMP_OUT, "w");
	fprintf (fp, "** DEBUG: EEMA_core_XX.dll HPF function **\n");
	fprintf (fp, "a = %11.6f, b = %11.6f, ini = %11.6f\n",a,b,ini);
	fprintf (fp, "Output:\n");
	for (i=0; i<N; i++) {
		fprintf (fp, "%11.6f\n",x[i]);
	}
	fclose(fp);
#endif //def DEBUG
	
	return (x);
}
